package net.sf.amateras.air.mxml.editparts;

import java.util.List;

import net.sf.amateras.air.mxml.editparts.policy.ResizeableFlowLayoutEditPolicy;
import net.sf.amateras.air.mxml.figures.BoxFigure;
import net.sf.amateras.air.mxml.models.BoxModel;
import net.sf.amateras.air.mxml.models.IComponentModel;
import net.sf.amateras.air.mxml.models.IContainerModel;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.gef.EditPolicy;
import org.eclipse.swt.graphics.RGB;

/**
 * The editpart for the {@link BoxModel}.
 * @author ogawahideko
 *
 */
public class BoxEditPart extends AbstractComponentEditPart {

	@Override
	protected IFigure createFigure() {
		BoxFigure figure = new BoxFigure();
		updateFigure((BoxModel) getModel(), figure);
		return figure;
	}

	@Override
	protected List<IComponentModel> getModelChildren() {
		return ((IContainerModel) getModel()).getChildren();
	}

	@Override
	protected void createEditPolicies() {
		super.createEditPolicies();
		installEditPolicy(EditPolicy.LAYOUT_ROLE, new ResizeableFlowLayoutEditPolicy());
	}

	@Override
	protected void refreshVisuals() {
		super.refreshVisuals();
		BoxModel model = (BoxModel) getModel();
		BoxFigure figure = (BoxFigure) getFigure();

		updateFigure(model, figure);
	}

	protected void updateFigure(BoxModel model, BoxFigure figure) {
		figure.setToolTip(new Label(model.toString()));
		String direction = (String) model.getAttribute(BoxModel.DIRECTION);
		if (direction.equalsIgnoreCase("vertical")) {
			figure.setVertical(true);
			try {
				figure.setSpacing(model.getAttributeToNumber(BoxModel.VERTICAL_GAP));
			} catch (NumberFormatException e) {
				//Nothing todo.
			}
		} else {
			figure.setVertical(false);
			try {
				figure.setSpacing(model.getAttributeToNumber(BoxModel.HORIZONTAL_GAP));
			} catch (NumberFormatException e) {
				//Nothing todo.
			}
		}

		try {
			int top = model.getAttributeToNumber(BoxModel.PADDING_TOP);
			int left = model.getAttributeToNumber(BoxModel.PADDING_LEFT);
			int right = model.getAttributeToNumber(BoxModel.PADDING_RIGHT);
			int bottom = model.getAttributeToNumber(BoxModel.PADDING_BOTTOM);
			figure.setPadding(new Insets(top, left, bottom, right));
		} catch (NumberFormatException e) {
			//Nothing todo.
		}

		figure.setBackgroundColor(getColor((RGB) model.getAttribute(BoxModel.BACKGROUND_COLOR)));

		figure.revalidate();
	}

}
