package net.sf.amateras.air.mxml.editparts;

import net.sf.amateras.air.mxml.figures.CheckBox;
import net.sf.amateras.air.mxml.models.CheckBoxModel;

import org.eclipse.draw2d.IFigure;

/**
 * The editpart for the {@link CheckBoxModel}.
 * 
 * @author ogawahideko
 */
public class CheckBoxEditPart extends ButtonEditPart {

	@Override
	protected IFigure createFigure() {
		CheckBox button = new CheckBox();
		updateFigure(button, (CheckBoxModel) getModel());
		return button;
	}

	@Override
	protected void refreshVisuals() {
		super.refreshVisuals();
		updateFigure((CheckBox) getFigure(), (CheckBoxModel) getModel());
	}

	private void updateFigure(CheckBox button, CheckBoxModel model) {
		super.updateFigure(button, model);

	}

}
