package net.sf.amateras.air.mxml.editparts;

import net.sf.amateras.air.AIRPlugin;
import net.sf.amateras.air.mxml.figures.DataGridColumnFigure;
import net.sf.amateras.air.mxml.models.DataGridColumnModel;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.swt.graphics.Color;

/**
 * The editpart for the {@link DataGridColumnModel}.
 * 
 * @author Hideko Ogawa
 */
public class DataGridColumnEditPart extends AbstractDirectEditPart {

	private static final int WIDTH = 100;

	@Override
	protected IFigure createFigure() {
		DataGridColumnModel model = (DataGridColumnModel) getModel();
		DataGridColumnFigure column = new DataGridColumnFigure();
		column.setWidth(column.getDefaultWidth());
		updateFigure(column, model);
		return column;
	}

	@Override
	protected void refreshVisuals() {
		super.refreshVisuals();
		updateFigure((DataGridColumnFigure) getFigure(), (DataGridColumnModel) getModel());
	}

	private void updateFigure(DataGridColumnFigure column, DataGridColumnModel model) {
		column.setText(model.getAttributeToString(DataGridColumnModel.HEADER_TEXT));
		Object swidth = model.getAttribute(DataGridColumnModel.WIDTH);

		try {
			column.setWidth(Integer.parseInt(swidth.toString()));
		} catch (NumberFormatException e) {
			column.setWidth(WIDTH);
		}

		AIRPlugin.getDefault().getFontManager().setFont(model, column);

		Color color = getColor(DataGridColumnModel.COLOR);
		if (color != null) {
			column.setHeaderForegroundColor(color);
		}

		Object align = model.getAttribute(DataGridColumnModel.TEXT_ALIGN);
		if (align != null) {
			if (align.toString().equals("right")) {
				column.setHeaderLabelAlignment(Label.RIGHT);
			} else if (align.toString().equals("center")) {
				column.setHeaderLabelAlignment(Label.CENTER);
			} else {
				column.setHeaderLabelAlignment(Label.LEFT);
			}
		}

		column.revalidate();
	}

	@Override
	protected String getDirectEditPropertyKey() {
		return DataGridColumnModel.HEADER_TEXT;
	}

	@Override
	protected IFigure getDirectEditFigure() {
		return ((DataGridColumnFigure) getFigure()).getTitleFigure();
	}

}
