package net.sf.amateras.air.mxml.editparts;

import java.util.List;

import net.sf.amateras.air.mxml.editparts.policy.ToolBarLayoutEditPolicy;
import net.sf.amateras.air.mxml.figures.DataGrid;
import net.sf.amateras.air.mxml.models.DataGridModel;
import net.sf.amateras.air.mxml.models.IComponentModel;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.gef.EditPolicy;

/**
 * The editpart for the {@link DataGridEditPart}.
 * 
 * @author ogawahideko
 */
public class DataGridEditPart extends AbstractComponentEditPart {

	@Override
	protected IFigure createFigure() {
		DataGrid grid = new DataGrid();
		updateFigure(grid, (DataGridModel) getModel());
		return grid;
	}

	@Override
	protected List<IComponentModel> getModelChildren() {
		return ((DataGridModel) getModel()).getChildren();
	}

	@Override
	protected void refreshVisuals() {
		super.refreshVisuals();
		updateFigure((DataGrid) getFigure(), (DataGridModel) getModel());
		refreshChildren();
	}

	private void updateFigure(DataGrid grid, DataGridModel model) {
		grid.setToolTip(new Label(model.toString()));

	}

	@Override
	protected void createEditPolicies() {
		super.createEditPolicies();
		installEditPolicy(EditPolicy.LAYOUT_ROLE, new ToolBarLayoutEditPolicy());
	}

}
