package net.sf.amateras.air.mxml.editparts;

import net.sf.amateras.air.AIRPlugin;
import net.sf.amateras.air.mxml.figures.DateFieldFigure;
import net.sf.amateras.air.mxml.models.ComboBoxModel;
import net.sf.amateras.air.mxml.models.DateFieldModel;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;

/**
 * The editpart for the {@link DateFieldModel}.
 * 
 * @author ogawahideko
 */
public class DateFieldEditPart extends AbstractComponentEditPart {

	@Override
	protected IFigure createFigure() {
		DateFieldFigure button = new DateFieldFigure();
		updateFigure(button, (DateFieldModel) getModel());
		return button;
	}

	@Override
	protected void refreshVisuals() {
		super.refreshVisuals();
		updateFigure((DateFieldFigure) getFigure(), (DateFieldModel) getModel());
	}

	private void updateFigure(DateFieldFigure figure, DateFieldModel model) {
		figure.setToolTip(new Label(model.toString()));
		AIRPlugin.getDefault().getFontManager().setFont(model, figure);

		if (model.getAttribute(ComboBoxModel.COLOR) != null) {
			figure.setForegroundColor(getColor(DateFieldModel.COLOR));
		}

	}

}
