package net.sf.amateras.air.mxml.editparts;

import net.sf.amateras.air.mxml.figures.BoxFigure;
import net.sf.amateras.air.mxml.models.SpacerModel;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;

/**
 * The editpart for the {@link SpacerModel}.
 * @author ogawahideko
 *
 */
public class SpacerEditPart extends AbstractComponentEditPart {

	@Override
	protected IFigure createFigure() {
		BoxFigure figure = new BoxFigure();
		updateFigure((SpacerModel) getModel(), figure);
		return figure;
	}

	@Override
	protected void refreshVisuals() {
		super.refreshVisuals();
		SpacerModel model = (SpacerModel) getModel();
		BoxFigure figure = (BoxFigure) getFigure();

		updateFigure(model, figure);
	}

	protected void updateFigure(SpacerModel model, BoxFigure figure) {
		figure.setToolTip(new Label(model.toString()));
	}

}
