package net.sf.amateras.air.mxml.editparts;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.tools.CellEditorLocator;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.widgets.Text;

public class TextCellEditorLocator implements CellEditorLocator {
	private IFigure figure;

	public TextCellEditorLocator(IFigure f) {
		figure = f;
	}

	public void relocate(CellEditor celleditor) {
		Text text = (Text) celleditor.getControl();
		Rectangle rect = figure.getBounds().getCopy();
		int gap = 2;
		if (figure instanceof Label) {
			Label original = (Label) figure;
			if (original.getIcon() != null) {
				gap += original.getIcon().getBounds().width;
				gap += original.getIconTextGap();
			}
			text.setFont(original.getFont());
		}

		figure.translateToAbsolute(rect);
		text.setBounds(rect.x + gap, rect.y + 2, rect.width - gap - 4, rect.height - 5);
	}
}
