package net.sf.amateras.air.mxml.editparts;

import net.sf.amateras.air.mxml.figures.BoxFigure;
import net.sf.amateras.air.mxml.models.VideoDisplayModel;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.swt.graphics.RGB;

/**
 * The editpart for the {@link VideoDisplayModel}.
 * 
 * @author ogawahideko
 */
public class VideoDisplayEditPart extends AbstractComponentEditPart {

	@Override
	protected IFigure createFigure() {
		BoxFigure box = new BoxFigure();
		box.setOpaque(true);
		updateFigure(box, (VideoDisplayModel) getModel());
		return box;
	}

	@Override
	protected void refreshVisuals() {
		super.refreshVisuals();
		updateFigure((BoxFigure) getFigure(), (VideoDisplayModel) getModel());
	}

	private void updateFigure(BoxFigure figure, VideoDisplayModel model) {
		figure.setToolTip(new Label(model.toString()));
		figure.setBackgroundColor(getColor((RGB) model.getAttribute(VideoDisplayModel.BACKGROUND_COLOR)));

		figure.repaint();
	}

}
