package net.sf.amateras.air.mxml.editparts.command;

import net.sf.amateras.air.mxml.models.AbstractComponentModel;
import net.sf.amateras.air.mxml.models.IComponentModel;
import net.sf.amateras.air.mxml.models.IContainerModel;

import org.eclipse.gef.commands.Command;

/**
 * DeleteCommand for {@link IComponentModel}.
 * @author ogawahideko
 *
 */
public class DeleteCommand extends Command {

	private IContainerModel parent;
	private IComponentModel model;

	@Override
	public void execute() {
		parent.removeChild(model);
	}

	public void setParentModel(Object parent) {
		if (parent instanceof IContainerModel) {
			this.parent = (IContainerModel) parent;
		}
	}

	public void setTargetModel(Object model) {
		if (model instanceof AbstractComponentModel) {
			this.model = (AbstractComponentModel) model;
		}
	}

	@Override
	public void undo() {
		parent.addChild(model);
	}

	@Override
	public boolean canExecute() {
		return parent != null && model != null ? true : false;
	}

}
