package net.sf.amateras.air.mxml.factory;

import java.util.ArrayList;
import java.util.List;

import net.sf.amateras.air.mxml.VisualMXMLEditor;
import net.sf.amateras.air.mxml.action.AddCanvasAction;
import net.sf.amateras.air.mxml.action.AddCanvasContributionItem;
import net.sf.amateras.air.mxml.action.AddGridDataColumnAction;
import net.sf.amateras.air.mxml.action.AddGridDataColumnContributionItem;
import net.sf.amateras.air.mxml.action.ChangeStackAction;
import net.sf.amateras.air.mxml.action.ChangeStackContributionItem;
import net.sf.amateras.air.mxml.action.IStructuredSelectionRefresh;
import net.sf.amateras.air.mxml.action.MoveDownAction;
import net.sf.amateras.air.mxml.action.MoveUpAction;
import net.sf.amateras.air.mxml.action.VisualMXMLRefreshAction;

import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.IPageSite;

/**
 * Create MenuAction and MenuManager.
 * @author ogawahideko
 *
 */
public class MenuFactory {
	public static final String MENU_GROUP_EDIT = "edit";
	public static final String MENU_GROUP_COMPONENT = "component";
	public static final String MENU_GROUP_ADDITIONS = "additions";

	private MoveUpAction moveUpAction;
	private MoveDownAction moveDownAction;
	private VisualMXMLRefreshAction refreshAction;
	private AddGridDataColumnAction addGridDataGridColumnAction;
	private AddCanvasAction addCanvasAction;
	private ChangeStackAction changeStackAction;
	private List<IStructuredSelectionRefresh> actions;
	private VisualMXMLEditor editor;

	public MenuFactory(VisualMXMLEditor editor) {
		this.editor = editor;
		actions = new ArrayList<IStructuredSelectionRefresh>();
		moveUpAction = new MoveUpAction(editor);
		moveDownAction = new MoveDownAction(editor);
		refreshAction = new VisualMXMLRefreshAction(editor);
		addGridDataGridColumnAction = new AddGridDataColumnAction(editor);
		addCanvasAction = new AddCanvasAction(editor);
		changeStackAction = new ChangeStackAction(editor);
		actions.add(moveUpAction);
		actions.add(moveDownAction);
		actions.add(refreshAction);
	}

	public List<IStructuredSelectionRefresh> getRefreshActions() {
		return actions;
	}

	public MenuManager createGraphicalViewerMenu() {
		MenuManager menuMgr = new MenuManager();
		menuMgr.add(new Separator(MENU_GROUP_EDIT));
		menuMgr.add(editor.getAction(ActionFactory.UNDO.getId()));
		menuMgr.add(editor.getAction(ActionFactory.REDO.getId()));
		menuMgr.add(editor.getAction(ActionFactory.DELETE.getId()));
		AddGridDataColumnContributionItem item = new AddGridDataColumnContributionItem(addGridDataGridColumnAction);
		actions.add(item);
		menuMgr.add(item);
		AddCanvasContributionItem item2 = new AddCanvasContributionItem(addCanvasAction);
		actions.add(item2);
		menuMgr.add(item2);
		menuMgr.add(new Separator(MENU_GROUP_COMPONENT));
		menuMgr.add(refreshAction);
		menuMgr.add(moveUpAction);
		menuMgr.add(moveDownAction);
		ChangeStackContributionItem item3 = new ChangeStackContributionItem(changeStackAction);
		actions.add(item3);
		menuMgr.add(item3);
		menuMgr.add(new Separator(MENU_GROUP_ADDITIONS));
		return menuMgr;
	}

	public void setOutLinePageMenu(IPageSite pageSite) {
		IActionBars bars = pageSite.getActionBars();
		String delId = ActionFactory.DELETE.getId();
		String undoId = ActionFactory.UNDO.getId();
		String redoId = ActionFactory.REDO.getId();
		bars.setGlobalActionHandler(delId, editor.getAction(delId));
		bars.setGlobalActionHandler(undoId, editor.getAction(undoId));
		bars.setGlobalActionHandler(redoId, editor.getAction(redoId));
		bars.updateActionBars();
	}

	public void setOutLineContextMenu(IMenuManager menuMgr) {
		menuMgr.add(new Separator(MENU_GROUP_EDIT));
		menuMgr.add(editor.getAction(ActionFactory.UNDO.getId()));
		menuMgr.add(editor.getAction(ActionFactory.REDO.getId()));
		menuMgr.add(editor.getAction(ActionFactory.DELETE.getId()));

		menuMgr.add(new Separator(MENU_GROUP_COMPONENT));
		menuMgr.add(refreshAction);
		menuMgr.add(moveUpAction);
		menuMgr.add(moveDownAction);
	}

	public MoveUpAction getMoveUpAction() {
		return moveUpAction;
	}

	public MoveDownAction getMoveDownAction() {
		return moveDownAction;
	}

}
