package net.sf.amateras.air.mxml.factory;

import net.sf.amateras.air.AIRPlugin;
import net.sf.amateras.air.mxml.editparts.AbstractEditPart;
import net.sf.amateras.air.mxml.editparts.AccordionEditPart;
import net.sf.amateras.air.mxml.editparts.ApplicationEditPart;
import net.sf.amateras.air.mxml.editparts.BoxEditPart;
import net.sf.amateras.air.mxml.editparts.ButtonEditPart;
import net.sf.amateras.air.mxml.editparts.CanvasEditPart;
import net.sf.amateras.air.mxml.editparts.CheckBoxEditPart;
import net.sf.amateras.air.mxml.editparts.ColorPickerEditPart;
import net.sf.amateras.air.mxml.editparts.ComboBoxEditPart;
import net.sf.amateras.air.mxml.editparts.DataGridColumnEditPart;
import net.sf.amateras.air.mxml.editparts.DataGridEditPart;
import net.sf.amateras.air.mxml.editparts.DateFieldEditPart;
import net.sf.amateras.air.mxml.editparts.HtmlEditPart;
import net.sf.amateras.air.mxml.editparts.ImageEditPart;
import net.sf.amateras.air.mxml.editparts.LabelEditPart;
import net.sf.amateras.air.mxml.editparts.LinkButtonEditPart;
import net.sf.amateras.air.mxml.editparts.ListEditPart;
import net.sf.amateras.air.mxml.editparts.PanelEditPart;
import net.sf.amateras.air.mxml.editparts.PopUpButtonEditPart;
import net.sf.amateras.air.mxml.editparts.RadioButtonEditPart;
import net.sf.amateras.air.mxml.editparts.RichTextEditorEditPart;
import net.sf.amateras.air.mxml.editparts.RootEditPart;
import net.sf.amateras.air.mxml.editparts.SWFLoaderEditPart;
import net.sf.amateras.air.mxml.editparts.SpacerEditPart;
import net.sf.amateras.air.mxml.editparts.TabNavigatorEditPart;
import net.sf.amateras.air.mxml.editparts.TextAreaEditPart;
import net.sf.amateras.air.mxml.editparts.TextInputEditPart;
import net.sf.amateras.air.mxml.editparts.TreeEditPart;
import net.sf.amateras.air.mxml.editparts.VideoDisplayEditPart;
import net.sf.amateras.air.mxml.editparts.ViewStackEditPart;
import net.sf.amateras.air.mxml.editparts.WindowEditPart;
import net.sf.amateras.air.mxml.models.AbstractContainerModel;
import net.sf.amateras.air.mxml.models.AccordionModel;
import net.sf.amateras.air.mxml.models.ApplicationControlBarModel;
import net.sf.amateras.air.mxml.models.ApplicationModel;
import net.sf.amateras.air.mxml.models.BoxModel;
import net.sf.amateras.air.mxml.models.ButtonModel;
import net.sf.amateras.air.mxml.models.CanvasModel;
import net.sf.amateras.air.mxml.models.CheckBoxModel;
import net.sf.amateras.air.mxml.models.ColorPickerModel;
import net.sf.amateras.air.mxml.models.ComboBoxModel;
import net.sf.amateras.air.mxml.models.ControlBarModel;
import net.sf.amateras.air.mxml.models.DataGridColumnModel;
import net.sf.amateras.air.mxml.models.DataGridModel;
import net.sf.amateras.air.mxml.models.DateFieldModel;
import net.sf.amateras.air.mxml.models.DividedBoxModel;
import net.sf.amateras.air.mxml.models.FileSystemComboBoxModel;
import net.sf.amateras.air.mxml.models.FileSystemDataGridModel;
import net.sf.amateras.air.mxml.models.FileSystemHistoryButtonModel;
import net.sf.amateras.air.mxml.models.FileSystemListModel;
import net.sf.amateras.air.mxml.models.FileSystemTreeModel;
import net.sf.amateras.air.mxml.models.HBoxModel;
import net.sf.amateras.air.mxml.models.HDividedBoxModel;
import net.sf.amateras.air.mxml.models.HtmlModel;
import net.sf.amateras.air.mxml.models.ImageModel;
import net.sf.amateras.air.mxml.models.LabelModel;
import net.sf.amateras.air.mxml.models.LinkButtonModel;
import net.sf.amateras.air.mxml.models.ListModel;
import net.sf.amateras.air.mxml.models.PanelModel;
import net.sf.amateras.air.mxml.models.PopUpButtonModel;
import net.sf.amateras.air.mxml.models.RadioButtonModel;
import net.sf.amateras.air.mxml.models.RichTextEditorModel;
import net.sf.amateras.air.mxml.models.RootModel;
import net.sf.amateras.air.mxml.models.SWFLoaderModel;
import net.sf.amateras.air.mxml.models.SpacerModel;
import net.sf.amateras.air.mxml.models.TabNavigatorModel;
import net.sf.amateras.air.mxml.models.TextAreaModel;
import net.sf.amateras.air.mxml.models.TextInputModel;
import net.sf.amateras.air.mxml.models.TextModel;
import net.sf.amateras.air.mxml.models.TitleWindowModel;
import net.sf.amateras.air.mxml.models.TreeModel;
import net.sf.amateras.air.mxml.models.VBoxModel;
import net.sf.amateras.air.mxml.models.VDividedBoxModel;
import net.sf.amateras.air.mxml.models.VideoDisplayModel;
import net.sf.amateras.air.mxml.models.ViewStackModel;
import net.sf.amateras.air.mxml.models.WindowModel;
import net.sf.amateras.air.mxml.models.WindowedApplicationModel;

import org.eclipse.gef.EditPart;
import org.eclipse.gef.palette.CreationToolEntry;
import org.eclipse.gef.palette.MarqueeToolEntry;
import org.eclipse.gef.palette.PaletteDrawer;
import org.eclipse.gef.palette.PaletteGroup;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.palette.PaletteStack;
import org.eclipse.gef.palette.SelectionToolEntry;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.gef.requests.SimpleFactory;
import org.eclipse.jface.resource.ImageDescriptor;

public class ModelFactory {

	private ModelFactory() {
	}

	public static PaletteRoot getPaletteRoot() {
		PaletteRoot root = new PaletteRoot();

		PaletteGroup tools = new PaletteGroup("Tools");
		// selection tool
		ToolEntry tool = new SelectionToolEntry();
		tools.add(tool);
		root.setDefaultEntry(tool);
		// marquee tool
		tool = new MarqueeToolEntry();
		tools.add(tool);

		// creation model tools
		PaletteDrawer html = new PaletteDrawer("Controls");

		PaletteStack labelStack = new PaletteStack("Label", "Label", null);
		html.add(labelStack);
		labelStack.add(createEntry(LabelModel.COMPONENT_NAME, LabelModel.PACKAGE_NAME, LabelModel.class, "label.gif"));

		labelStack.add(createEntry(TextModel.COMPONENT_NAME, TextModel.PACKAGE_NAME, TextModel.class, "text.gif"));

		// Text
		PaletteStack textStack = new PaletteStack("TextInput", "TextInput", null);
		html.add(textStack);
		textStack.add(createEntry(TextInputModel.COMPONENT_NAME, TextInputModel.PACKAGE_NAME, TextInputModel.class,
				"textinput.gif"));
		textStack.add(createEntry(DateFieldModel.COMPONENT_NAME, DateFieldModel.PACKAGE_NAME, DateFieldModel.class,
				"textinput.gif"));

		//TextArea
		PaletteStack araStack = new PaletteStack("TextArea", "TextArea", null);
		html.add(araStack);
		araStack.add(createEntry(TextAreaModel.COMPONENT_NAME, TextAreaModel.PACKAGE_NAME, TextAreaModel.class,
				"textarea.gif"));

		araStack.add(createEntry(RichTextEditorModel.COMPONENT_NAME, RichTextEditorModel.PACKAGE_NAME,
				RichTextEditorModel.class, "richtext.gif"));

		// button
		PaletteStack buttonStack = new PaletteStack("Button", "Button", null);
		html.add(buttonStack);
		buttonStack.add(createEntry(ButtonModel.COMPONENT_NAME, ButtonModel.PACKAGE_NAME, ButtonModel.class,
				"button.gif"));

		buttonStack.add(createEntry(PopUpButtonModel.COMPONENT_NAME, PopUpButtonModel.PACKAGE_NAME,
				PopUpButtonModel.class, "combobox.gif"));

		buttonStack.add(createEntry(FileSystemHistoryButtonModel.COMPONENT_NAME,
				FileSystemHistoryButtonModel.PACKAGE_NAME, FileSystemHistoryButtonModel.class, "combobox.gif"));
		buttonStack.add(createEntry(LinkButtonModel.COMPONENT_NAME, LinkButtonModel.PACKAGE_NAME,
				LinkButtonModel.class, "button.gif"));

		html.add(createEntry(CheckBoxModel.COMPONENT_NAME, CheckBoxModel.PACKAGE_NAME, CheckBoxModel.class,
				"checkbox.gif"));

		html.add(createEntry(RadioButtonModel.COMPONENT_NAME, RadioButtonModel.PACKAGE_NAME, RadioButtonModel.class,
				"radio.gif"));

		PaletteStack comboStack = new PaletteStack("ComboBox", "ComboBox", null);
		html.add(comboStack);
		comboStack.add(createEntry(ComboBoxModel.COMPONENT_NAME, ComboBoxModel.PACKAGE_NAME, ComboBoxModel.class,
				"combobox.gif"));

		comboStack.add(createEntry(FileSystemComboBoxModel.COMPONENT_NAME, FileSystemComboBoxModel.PACKAGE_NAME,
				FileSystemComboBoxModel.class, "combobox.gif"));

		// DataGrid
		PaletteStack gridStack = new PaletteStack("DataGrid", "DataGrid", null);
		html.add(gridStack);

		gridStack.add(createEntry(DataGridModel.COMPONENT_NAME, DataGridModel.PACKAGE_NAME, DataGridModel.class,
				"table.gif"));

		gridStack.add(createEntry(FileSystemDataGridModel.COMPONENT_NAME, FileSystemDataGridModel.PACKAGE_NAME,
				FileSystemDataGridModel.class, "table.gif"));

		//List
		PaletteStack listStack = new PaletteStack("List", "List", null);
		html.add(listStack);
		listStack.add(createEntry(ListModel.COMPONENT_NAME, ListModel.PACKAGE_NAME, ListModel.class, "list.gif"));
		listStack.add(createEntry(FileSystemListModel.COMPONENT_NAME, FileSystemListModel.PACKAGE_NAME,
				FileSystemListModel.class, "list.gif"));

		PaletteStack treeStack = new PaletteStack("Tree", "Tree", null);
		html.add(treeStack);
		treeStack.add(createEntry(TreeModel.COMPONENT_NAME, TreeModel.PACKAGE_NAME, TreeModel.class, "tree.gif"));

		treeStack.add(createEntry(FileSystemTreeModel.COMPONENT_NAME, FileSystemTreeModel.PACKAGE_NAME,
				FileSystemTreeModel.class, "tree.gif"));

		// Display
		html.add(createEntry(ImageModel.COMPONENT_NAME, ImageModel.PACKAGE_NAME, ImageModel.class, "image.gif"));

		html.add(createEntry(SWFLoaderModel.COMPONENT_NAME, SWFLoaderModel.PACKAGE_NAME, SWFLoaderModel.class,
				"swf.gif"));

		html.add(createEntry(HtmlModel.COMPONENT_NAME, HtmlModel.PACKAGE_NAME, HtmlModel.class, "html.gif"));

		html.add(createEntry(VideoDisplayModel.COMPONENT_NAME, VideoDisplayModel.PACKAGE_NAME, VideoDisplayModel.class,
				"video.gif"));

		html.add(createEntry(ColorPickerModel.COMPONENT_NAME, ColorPickerModel.PACKAGE_NAME, ColorPickerModel.class,
				"ColorPicker.png"));

		html.add(createEntry(SpacerModel.COMPONENT_NAME, SpacerModel.PACKAGE_NAME, SpacerModel.class, "canvas.gif"));

		// Container
		PaletteDrawer container = new PaletteDrawer("Container");
		container.add(createEntry(PanelModel.COMPONENT_NAME, AbstractContainerModel.PACKAGE_NAME, PanelModel.class,
				"panel.gif"));

		PaletteStack boxStack = new PaletteStack("Box", "Box", null);
		container.add(boxStack);
		boxStack.add(createEntry(BoxModel.COMPONENT_NAME, AbstractContainerModel.PACKAGE_NAME, BoxModel.class,
				"box.gif"));

		boxStack.add(createEntry(VBoxModel.COMPONENT_NAME, AbstractContainerModel.PACKAGE_NAME, VBoxModel.class,
				"vbox.gif"));

		boxStack.add(createEntry(HBoxModel.COMPONENT_NAME, AbstractContainerModel.PACKAGE_NAME, HBoxModel.class,
				"hbox.gif"));

		// DividedBox
		PaletteStack vboxStack = new PaletteStack("DividedBox", "DividedBox", null);
		container.add(vboxStack);

		vboxStack.add(createEntry(DividedBoxModel.COMPONENT_NAME, AbstractContainerModel.PACKAGE_NAME,
				VDividedBoxModel.class, "vdivided.gif"));

		vboxStack.add(createEntry(HDividedBoxModel.COMPONENT_NAME, AbstractContainerModel.PACKAGE_NAME,
				HDividedBoxModel.class, "hdivided.gif"));

		container.add(createEntry(TabNavigatorModel.COMPONENT_NAME, AbstractContainerModel.PACKAGE_NAME,
				TabNavigatorModel.class, "tab.gif"));

		container.add(createEntry(AccordionModel.COMPONENT_NAME, AbstractContainerModel.PACKAGE_NAME,
				AccordionModel.class, "accordion.gif"));

		container.add(createEntry(CanvasModel.COMPONENT_NAME, AbstractContainerModel.PACKAGE_NAME, CanvasModel.class,
				"canvas.gif"));

		container.add(createEntry(ViewStackModel.COMPONENT_NAME, AbstractContainerModel.PACKAGE_NAME,
				ViewStackModel.class, "canvas.gif"));

		PaletteStack controlBarStack = new PaletteStack("ControlBar", "ControlBar", null);
		container.add(controlBarStack);
		controlBarStack.add(createEntry(ControlBarModel.COMPONENT_NAME, AbstractContainerModel.PACKAGE_NAME,
				ControlBarModel.class, "controlbar.gif"));
		controlBarStack.add(createEntry(ApplicationControlBarModel.COMPONENT_NAME,
				ApplicationControlBarModel.PACKAGE_NAME, ApplicationControlBarModel.class, "controlbar.gif"));

		// adds groups to the root.
		root.add(tools);
		root.add(html);
		root.add(container);
		return root;
	}

	public static EditPart createEditPart(Object model) {
		AbstractEditPart editPart = null;
		if (model.getClass() == RootModel.class) {
			editPart = new RootEditPart();
		} else if (model.getClass() == WindowedApplicationModel.class) {
			editPart = new ApplicationEditPart();
		} else if (model.getClass() == ApplicationModel.class) {
			editPart = new ApplicationEditPart();
		} else if (model.getClass() == WindowModel.class) {
			editPart = new WindowEditPart();
		} else if (model.getClass() == TitleWindowModel.class) {
			editPart = new PanelEditPart();

		} else if (model.getClass() == LabelModel.class) {
			editPart = new LabelEditPart();
		} else if (model.getClass() == TextModel.class) {
			editPart = new LabelEditPart();

		} else if (model.getClass() == CheckBoxModel.class) {
			editPart = new CheckBoxEditPart();
		} else if (model.getClass() == RadioButtonModel.class) {
			editPart = new RadioButtonEditPart();
		} else if (model.getClass() == ButtonModel.class) {
			editPart = new ButtonEditPart();
		} else if (model.getClass() == PopUpButtonModel.class) {
			editPart = new PopUpButtonEditPart();
		} else if (model.getClass() == FileSystemHistoryButtonModel.class) {
			editPart = new PopUpButtonEditPart();
		} else if (model.getClass() == LinkButtonModel.class) {
			editPart = new LinkButtonEditPart();

		} else if (model.getClass() == TextAreaModel.class) {
			editPart = new TextAreaEditPart();
		} else if (model.getClass() == TextInputModel.class) {
			editPart = new TextInputEditPart();
		} else if (model.getClass() == DateFieldModel.class) {
			editPart = new DateFieldEditPart();
		} else if (model.getClass() == ImageModel.class) {
			editPart = new ImageEditPart();
		} else if (model.getClass() == RichTextEditorModel.class) {
			editPart = new RichTextEditorEditPart();

		} else if (model.getClass() == ComboBoxModel.class) {
			editPart = new ComboBoxEditPart();
		} else if (model.getClass() == FileSystemComboBoxModel.class) {
			editPart = new ComboBoxEditPart();

		} else if (model.getClass() == DataGridModel.class) {
			editPart = new DataGridEditPart();
		} else if (model.getClass() == FileSystemDataGridModel.class) {
			editPart = new DataGridEditPart();
		} else if (model.getClass() == DataGridColumnModel.class) {
			editPart = new DataGridColumnEditPart();
		} else if (model.getClass() == ListModel.class) {
			editPart = new ListEditPart();
		} else if (model.getClass() == FileSystemListModel.class) {
			editPart = new ListEditPart();

		} else if (model.getClass() == TreeModel.class) {
			editPart = new TreeEditPart();

		} else if (model.getClass() == FileSystemTreeModel.class) {
			editPart = new TreeEditPart();

		} else if (model.getClass() == HtmlModel.class) {
			editPart = new HtmlEditPart();

		} else if (model.getClass() == VideoDisplayModel.class) {
			editPart = new VideoDisplayEditPart();
		} else if (model.getClass() == SWFLoaderModel.class) {
			editPart = new SWFLoaderEditPart();
		} else if (model.getClass() == ColorPickerModel.class) {
			editPart = new ColorPickerEditPart();

			//Layout
		} else if (model.getClass() == BoxModel.class) {
			editPart = new BoxEditPart();
		} else if (model.getClass() == HBoxModel.class) {
			editPart = new BoxEditPart();
		} else if (model.getClass() == VBoxModel.class) {
			editPart = new BoxEditPart();
		} else if (model.getClass() == VDividedBoxModel.class) {
			editPart = new BoxEditPart();
		} else if (model.getClass() == HDividedBoxModel.class) {
			editPart = new BoxEditPart();
		} else if (model.getClass() == ControlBarModel.class) {
			editPart = new BoxEditPart();
		} else if (model.getClass() == ApplicationControlBarModel.class) {
			editPart = new BoxEditPart();
		} else if (model.getClass() == PanelModel.class) {
			editPart = new PanelEditPart();
		} else if (model.getClass() == AccordionModel.class) {
			editPart = new AccordionEditPart();
		} else if (model.getClass() == CanvasModel.class) {
			editPart = new CanvasEditPart();
		} else if (model.getClass() == TabNavigatorModel.class) {
			editPart = new TabNavigatorEditPart();
		} else if (model.getClass() == ViewStackModel.class) {
			editPart = new ViewStackEditPart();
		} else if (model.getClass() == SpacerModel.class) {
			editPart = new SpacerEditPart();
		} else {
			System.err.println("UnnoneEditPart for " + model);
		}

		if (editPart != null) {
			editPart.setModel(model);
		}
		return editPart;
	}

	private static CreationToolEntry createEntry(String componentName, String packageName, Class<?> clazz,
			String fileName) {
		ImageDescriptor image = getImage(fileName);
		CreationToolEntry entry = new CreationToolEntry(componentName, packageName + "." + componentName,
				new SimpleFactory(clazz), image, image);
		return entry;
	}

	private static ImageDescriptor getImage(String fileName) {
		return AIRPlugin.getImageDescriptor("icons/" + fileName);
	}

}
