package net.sf.amateras.air.mxml.figures;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.swt.graphics.Color;

public class LinedMarginBorder extends LineBorder {

	private Insets paddingInsets;
	private int borderWidth;
	private Color borderColor;

	public LinedMarginBorder(Insets paddingInsets, int borderWidth, Color borderColor) {
		this.paddingInsets = paddingInsets;
		this.borderColor = borderColor;
		this.borderWidth = borderWidth;
	}

	@Override
	public Insets getInsets(IFigure figure) {
		return new Insets(paddingInsets.top + borderWidth, paddingInsets.left + borderWidth, paddingInsets.bottom
				+ borderWidth, paddingInsets.right + borderWidth);
	}

	public void setPaddingInsets(Insets insets) {
		this.paddingInsets = insets;
	}

	@Override
	public Color getColor() {
		return borderColor;
	}

	@Override
	public int getWidth() {
		return borderWidth;
	}

	@Override
	public void paint(IFigure figure, Graphics graphics, Insets insets) {
		super.paint(figure, graphics, insets);
		//		graphics.setForegroundColor(borderColor);
		//		int x = figure.getBounds().x;
		//		int y = figure.getBounds().y;
		//		int width = figure.getBounds().width;
		//
		//		graphics.setLineWidth(borderInsets.top);
		//		graphics.drawLine(x, y + borderInsets.top / 2, x + width, y + borderInsets.top / 2);
		//		if (title != null) {
		//			if (titleColor != null) {
		//				graphics.setForegroundColor(titleColor);
		//			}
		//
		//			graphics.drawString(title, x + borderInsets.top / 2, y + 10);
		//		}
	}

	public Color getBorderColor() {
		return borderColor;
	}

	public void setBorderColor(Color borderColor) {
		this.borderColor = borderColor;
	}

}
