package net.sf.amateras.air.mxml.figures;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.SchemeBorder;
import org.eclipse.draw2d.ScrollBar;
import org.eclipse.draw2d.ButtonBorder.ButtonScheme;
import org.eclipse.swt.graphics.Color;

/**
 * 
 * @author Naoki Takezoe
 */
public class TextArea extends AbstractFigure implements ColorConstants {

	private static final int DEFAULT_HEIGHT = 44;
	private static final int DEFAULT_WIDTH = 160;
	private Label text;

	public TextArea() {
		this("");
	}

	public TextArea(String s) {
		CustomBorderLayout layout = new CustomBorderLayout();
		layout.setStretchCenterHeight(true);
		layout.setStretchCenterWidth(true);
		layout.setFillBottomAndTop(false);
		setLayoutManager(layout);
		setBackgroundColor(button);
		setOpaque(true);

		ScrollBar vbar = new ScrollBar();
		vbar.setOrientation(ScrollBar.VERTICAL);
		vbar.setMaximum(0);

		//		ScrollBar hbar = new ScrollBar();
		//		hbar.setOrientation(ScrollBar.HORIZONTAL);
		//		hbar.setMaximum(0);

		text = new Label();
		text.setText(s);
		text.setBackgroundColor(white);
		text.setOpaque(true);
		text.setLabelAlignment(Label.LEFT);
		text.setTextAlignment(Label.TOP);

		add(text, CustomBorderLayout.CENTER);
		add(vbar, CustomBorderLayout.RIGHT);
		//		add(hbar, CustomBorderLayout.BOTTOM);

		setBorder(new SchemeBorder(new ButtonScheme(new Color[] { buttonDarkest, buttonDarker }, new Color[] {
				buttonLightest, buttonDarker })));
	}

	public void setText(String s) {
		text.setText(s);
	}

	public String getText() {
		return text.getText();
	}

	public Label getTextFigure() {
		return text;
	}

	public int getDefaultWidth() {
		return DEFAULT_WIDTH;
	}

	public int getDefaultHeight() {
		return DEFAULT_HEIGHT;
	}

}
