package net.sf.amateras.air.mxml.figures;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.geometry.Insets;

/**
 * 
 * @author ogawahideko
 *
 */
public class ViewStackFigure extends ContainerFigure {
	private StackLayout layout;
	private IFigure selectedFigure;

	public ViewStackFigure() {
		layout = new StackLayout();
		setLayoutManager(layout);
		setBorder(new ViewStackBorder());
	}

	public IFigure getSelectedFigure() {
		return selectedFigure;
	}

	@Override
	public void add(IFigure figure, Object constraint, int index) {
		super.add(figure, constraint, index);
		if (selectedFigure == null) {
			selectedFigure = figure;
			selectedFigure.setVisible(true);
		} else {
			figure.setVisible(false);
		}
	}

	public void setSelectedIndex(int index) {
		for (int i = 0; i < getChildren().size(); i++) {
			IFigure child = (IFigure) getChildren().get(i);
			if (i == index) {
				selectedFigure = child;
				selectedFigure.setVisible(true);

			} else {
				child.setVisible(false);
			}
		}
	}

	class ViewStackBorder extends LineBorder {
		public ViewStackBorder() {
			super(ColorConstants.lightGray, 1);
		}

		@Override
		public Insets getInsets(IFigure figure) {
			return new Insets(1, 1, 1, 7);
		}

		@Override
		public void paint(IFigure figure, Graphics graphics, Insets insets) {
			super.paint(figure, graphics, insets);
			try {
				graphics.setForegroundColor(getColor());
				int x = figure.getBounds().x;
				int y = figure.getBounds().y;
				int width = figure.getBounds().width;
				int height = figure.getBounds().height;

				graphics.setLineWidth(1);
				graphics.drawLine(x + width - 3, y, x + width - 3, y + height);
				graphics.drawLine(x + width - 5, y, x + width - 5, y + height);

			} catch (Exception e) {
				e.printStackTrace();
			}
		}
	}

}
