package net.sf.amateras.air.mxml.figures.layouts;

import net.sf.amateras.air.mxml.models.FlexRectangle;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Dimension;

/**
 * 
 * @author ogawahideko
 *
 */
public class XYAbsoluteLayout extends XYLayout {

	@Override
	protected Dimension calculatePreferredSize(IFigure figure, int wHint, int hHint) {
		return SizeLibrary.getUseSize(figure, wHint, hHint);
	}

	@Override
	public Dimension getPreferredSize(IFigure container, int hint, int hint2) {
		return SizeLibrary.getUseSize(container, hint, hint2);
	}

	@Override
	public Object getConstraint(IFigure figure) {
		Object constraint = super.getConstraint(figure);
		if (constraint instanceof FlexRectangle) {
			FlexRectangle rectangle = (FlexRectangle) constraint;
			if (rectangle.isNeedCalculateWidth()) {
				Dimension useSize = SizeLibrary.getUseSize(figure, -1, -1);
				rectangle.width = useSize.width;
			}

			if (rectangle.isNeedCalculateHeight()) {
				Dimension useSize = SizeLibrary.getUseSize(figure, -1, -1);
				rectangle.height = useSize.height;
			}
		}
		return constraint;
	}

}
