package net.sf.amateras.air.mxml.models;

/**
 * Model of mx.controls.HTML
 * @author Hideko Ogawa
 *
 */
public class HtmlModel extends AbstractComponentModel implements IInstallDefault {
	public static final String PACKAGE_NAME = "mx.controls";
	public static final String COMPONENT_NAME = "HTML";

	public static final String DATA = "data";
	public static final String HISTORY_POSITION = "historyPosition";
	public static final String HTML_HOST = "htmlHost";
	public static final String HTML_LOADER_FACTORY = "htmlLoaderFactory";
	public static final String HTML_TEXT = "htmlText";
	public static final String LIST_DATA = "listData";
	public static final String LOCATION = "location";
	public static final String PAINTS_DEFAULT_BACKGROUND = "paintsDefaultBackground";
	public static final String RUNTIME_APPLICATION_DOMAIN = "runtimeApplicationDomain";
	public static final String USER_AGENT = "userAgent";

	public static final String PADDING_TOP = "paddingTop";
	public static final String PADDING_BOTTOM = "paddingBottom";
	public static final String PADDING_LEFT = "paddingLeft";
	public static final String PADDING_RIGHT = "paddingRight";

	public static final String COMPLETE = "complete";
	public static final String HTML_DOM_INITIALIZE = "htmlDOMInitialize";
	public static final String HTML_RENDER = "htmlRender";
	public static final String LOCATION_CHANGE = "locationChange";
	public static final String UNCAUGHT_SCRIPT_EXCEPTION = "uncaughtScriptException";

	@Override
	protected void installModelProperty() {
		super.installModelProperty();

		addStringModelProperty(DATA, CATEGORY_PROPERTY);
		addNumberModelProperty(HISTORY_POSITION, CATEGORY_PROPERTY, 1);
		addStringModelProperty(HTML_HOST, CATEGORY_PROPERTY);
		addStringModelProperty(HTML_LOADER_FACTORY, CATEGORY_PROPERTY);
		addStringModelProperty(HTML_TEXT, CATEGORY_PROPERTY);
		addStringModelProperty(LIST_DATA, CATEGORY_PROPERTY);
		addStringModelProperty(LOCATION, CATEGORY_PROPERTY);
		addBooleanModelProperty(PAINTS_DEFAULT_BACKGROUND, CATEGORY_PROPERTY, false);
		addStringModelProperty(RUNTIME_APPLICATION_DOMAIN, CATEGORY_PROPERTY);
		addStringModelProperty(USER_AGENT, CATEGORY_PROPERTY);

		addNumberModelProperty(PADDING_TOP, CATEGORY_STYLE, 0);
		addNumberModelProperty(PADDING_BOTTOM, CATEGORY_STYLE, 0);
		addNumberModelProperty(PADDING_LEFT, CATEGORY_STYLE, 0);
		addNumberModelProperty(PADDING_RIGHT, CATEGORY_STYLE, 0);

		addStringModelProperty(COMPLETE, CATEGORY_EVENT);
		addStringModelProperty(HTML_DOM_INITIALIZE, CATEGORY_EVENT);
		addStringModelProperty(HTML_RENDER, CATEGORY_EVENT);
		addStringModelProperty(LOCATION_CHANGE, CATEGORY_EVENT);
		addStringModelProperty(UNCAUGHT_SCRIPT_EXCEPTION, CATEGORY_EVENT);

	}

	/**
	 * implement {@link IInstallDefault}
	 */
	public void installDefault() {
		setAttribute(LOCATION, "http://www.adobe.com/products/air/");
	}

	@Override
	protected String getComponentName() {
		return COMPONENT_NAME;
	}

	@Override
	public String getFlexModelPackageName() {
		return PACKAGE_NAME;
	}

}
