package net.sf.amateras.air.mxml.models;

import net.sf.amateras.air.util.ColorUtil;

/**
 * Model of mx.controls.Label.
 * 
 * @author ogawahideko
 *
 */
public class LabelModel extends AbstractComponentModel {
	private static final int DEFAULT_HEIGHT = 18;
	private static final int DEFAULT_WIDTH = 32;
	public static final String COMPONENT_NAME = "Label";
	public static final String PACKAGE_NAME = "mx.controls";

	//Property
	public static final String CONDENSE_WHITE = "condenseWhite";
	public static final String DATA = "data";
	public static final String HTML_TEXT = "htmlText";
	public static final String LIST_DATA = "listData";
	public static final String SELECTABLE = "selectable";
	public static final String TEXT = "text";
	public static final String TRUNCATE_TO_FIT = "truncateToFit";

	//style
	public static final String COLOR = "color";
	public static final String DISABLED_COLOR = "disabledColor";
	public static final String FONT_ANTI_ALIAS_TYPE = "fontAntiAliasType";
	public static final String FONT_FAMILY = "fontFamily";
	public static final String FONT_GRID_FIT_TYPE = "fontGridFitType";
	public static final String FONT_SHARPNESS = "fontSharpness";
	public static final String FONT_SIZE = "fontSize";
	public static final String FONT_STYLE = "fontStyle";
	public static final String FONT_THICKNESS = "fontThickness";
	public static final String FONT_WEIGHT = "fontWeight";
	public static final String PADDING_LEFT = "paddingLeft";
	public static final String PADDING_RIGHT = "paddingRight";
	public static final String PADDING_TOP = "paddingTop";
	public static final String PADDING_BOTTOM = "paddingBottom";
	public static final String TEXT_ALIGN = "textAlign";
	public static final String TEXT_DECORATION = "textDecoration";
	public static final String TEXT_INDENT = "textIndent";

	//Event
	public static final String DATA_CHANGE = "dataChange";

	@Override
	protected void installModelProperty() {
		super.installModelProperty();
		addStringModelProperty(TEXT, CATEGORY_PROPERTY);
		addBooleanModelProperty(CONDENSE_WHITE, CATEGORY_PROPERTY, true);
		addStringModelProperty(HTML_TEXT, CATEGORY_PROPERTY);
		addBooleanModelProperty(SELECTABLE, CATEGORY_PROPERTY, true);
		addBooleanModelProperty(TRUNCATE_TO_FIT, CATEGORY_PROPERTY, true);

		addColorModelProperty(COLOR, CATEGORY_STYLE, ColorUtil.toRGB("#0B333C"));
		addColorModelProperty(DISABLED_COLOR, CATEGORY_STYLE, ColorUtil.toRGB("#AAB3B3"));
		addListModelProperty(FONT_ANTI_ALIAS_TYPE, CATEGORY_STYLE, LIST_FONT_ALIAS_TYPE);
		addStringModelProperty(FONT_FAMILY, CATEGORY_STYLE, "Verdana");
		addListModelProperty(FONT_GRID_FIT_TYPE, CATEGORY_STYLE, LIST_GRID_FIT_TYPE);
		addNumberModelProperty(FONT_SHARPNESS, CATEGORY_STYLE, 0);
		addNumberModelProperty(FONT_SIZE, CATEGORY_STYLE, 10);
		addListModelProperty(FONT_STYLE, CATEGORY_STYLE, LIST_FONT_STYLE);
		addNumberModelProperty(FONT_THICKNESS, CATEGORY_STYLE, 0);
		addListModelProperty(FONT_WEIGHT, CATEGORY_STYLE, LIST_FONT_WEIGHT);
		addNumberModelProperty(PADDING_LEFT, CATEGORY_STYLE, 0);
		addNumberModelProperty(PADDING_RIGHT, CATEGORY_STYLE, 0);
		addNumberModelProperty(PADDING_TOP, CATEGORY_STYLE, 0);
		addNumberModelProperty(PADDING_BOTTOM, CATEGORY_STYLE, 0);
		addListModelProperty(TEXT_ALIGN, CATEGORY_STYLE, LIST_LEFT_RIGHT_CENTER);
		addListModelProperty(TEXT_DECORATION, CATEGORY_STYLE, LIST_TEXT_DECORATION);
		addNumberModelProperty(TEXT_INDENT, CATEGORY_STYLE, 0);

		addStringModelProperty(DATA_CHANGE, CATEGORY_EVENT);
	}

	@Override
	protected String getComponentName() {
		return COMPONENT_NAME;
	}

	@Override
	public String getFlexModelPackageName() {
		return PACKAGE_NAME;
	}

	public int getDefaultWidth() {
		return DEFAULT_WIDTH;
	}

	public int getDefaultHeight() {
		return DEFAULT_HEIGHT;
	}

}
