package net.sf.amateras.air.mxml.models;

import net.sf.amateras.air.util.ColorUtil;

/**
 * model of mx.controls.PopUpButton
 * 
 * @author ogawahideko
 *
 */
public class PopUpButtonModel extends ButtonModel {

	private static final int OPEN_DURATION_DEFAULT_VALUE = 250;

	private static final int CLOSE_DURATION_DEFAULT_VALUE = 160;

	public static final String COMPONENT_NAME = "PopUpButton";

	public static final String OPEN_ALWAYS = "openAlways";
	public static final String POPUP = "popUp";

	public static final String ARROW_BUTTON_WIDTH = "arrowButtonWidth";
	public static final String CLOSE_DURATION = "closeDuration";
	public static final String CLOSE_EASING_FUNCTION = "closeEasingFunction";
	public static final String DISABLED_ICON_COLOR = "disabledIconColor";
	public static final String ICON_COLOR = "iconColor";
	public static final String OPEN_DURATION = "openDuration";
	public static final String OPEN_EASING_FUNCTION = "openEasingFunction";
	public static final String POP_UP_DOWN_SKIN = "popUpDownSkin";
	public static final String POP_UP_GAP = "popUpGap";
	public static final String POP_UP_ICON = "popUpIcon";
	public static final String POP_UP_OVER_SKIN = "popUpOverSkin";

	public static final String CLOSE = "close";
	public static final String OPEN = "open";

	@Override
	protected void installModelProperty() {
		super.installModelProperty();
		addBooleanModelProperty(OPEN_ALWAYS, CATEGORY_PROPERTY, false);
		addStringModelProperty(POPUP, CATEGORY_PROPERTY);

		addNumberModelProperty(ARROW_BUTTON_WIDTH, CATEGORY_STYLE, 16);
		addNumberModelProperty(CLOSE_DURATION, CATEGORY_STYLE, CLOSE_DURATION_DEFAULT_VALUE);
		addStringModelProperty(CLOSE_EASING_FUNCTION, CATEGORY_STYLE);
		addColorModelProperty(DISABLED_ICON_COLOR, CATEGORY_STYLE, ColorUtil.toRGB("#999999"));
		addColorModelProperty(ICON_COLOR, CATEGORY_STYLE, ColorUtil.toRGB("#111111"));
		addNumberModelProperty(OPEN_DURATION, CATEGORY_STYLE, OPEN_DURATION_DEFAULT_VALUE);
		addStringModelProperty(OPEN_EASING_FUNCTION, CATEGORY_STYLE);
		addStringModelProperty(POP_UP_DOWN_SKIN, CATEGORY_STYLE);
		addNumberModelProperty(POP_UP_GAP, CATEGORY_STYLE, 0);
		addStringModelProperty(POP_UP_ICON, CATEGORY_STYLE);
		addStringModelProperty(POP_UP_OVER_SKIN, CATEGORY_STYLE);

		addStringModelProperty(CLOSE, CATEGORY_EVENT);
		addStringModelProperty(OPEN, CATEGORY_EVENT);
	}

	@Override
	protected String getComponentName() {
		return COMPONENT_NAME;
	}
}
