package net.sf.amateras.air.mxml.models;

/**
 * Model of mx.controls.RichTextEditor
 * 
 * @author ogawahideko
 */
public class RichTextEditorModel extends PanelModel {
	private static final int DEFAULT_WIDTH = 325;
	private static final int DEFAULT_HEIGHT = 300;
	public static final String PACKAGE_NAME = "mx.controls";
	public static final String COMPONENT_NAME = "RichTextEditor";

	public static final String DEFAULT_LINK_PROTOCOL = "defaultLinkProtocol";
	public static final String HTML_TEXT = "htmlText";
	public static final String SHOW_CONTROL_BAR = "showControlBar";
	public static final String SHOW_TOOL_TIPS = "showToolTips";
	public static final String TEXT = "text";

	public static final String CHANGE = "change";

	@Override
	protected void installModelProperty() {
		super.installModelProperty();
		addStringModelProperty(DEFAULT_LINK_PROTOCOL, CATEGORY_PROPERTY, "http://");
		addStringModelProperty(HTML_TEXT, CATEGORY_PROPERTY);
		addBooleanModelProperty(SHOW_CONTROL_BAR, CATEGORY_PROPERTY, true);
		addBooleanModelProperty(SHOW_TOOL_TIPS, CATEGORY_PROPERTY, false);
		addStringModelProperty(TEXT, CATEGORY_PROPERTY);

		addStringModelProperty(CHANGE, CATEGORY_EVENT);
	}

	@Override
	public int getDefaultHeight() {
		return DEFAULT_HEIGHT;
	}

	@Override
	public int getDefaultWidth() {
		return DEFAULT_WIDTH;
	}

	@Override
	protected String getComponentName() {
		return COMPONENT_NAME;
	}

	@Override
	public String getFlexModelPackageName() {
		return PACKAGE_NAME;
	}
}
