package net.sf.amateras.air.mxml.models;

/**
 * Model of mx.controls.SWFLoader
 * 
 * @author ogawahideko
 */
public class SWFLoaderModel extends AbstractComponentModel {
	private static final int DEFAULT_WIDTH = 50;
	private static final int DEFAULT_HEIGHT = 50;
	public static final String PACKAGE_NAME = "mx.controls";
	public static final String COMPONENT_NAME = "SWFLoader";

	//properties
	public static final String AUTO_LOAD = "autoLoad";
	public static final String LOADER_CONTENT = "loaderContext";
	public static final String MAINTAIN_ASPECT_RATIO = "maintainAspectRatio";
	public static final String SCALE_CONTENT = "scaleContent";
	public static final String SHOW_BUSY_CURSOR = "showBusyCursor";
	public static final String SOURCE = "source";
	public static final String TRUST_CONTENT = "trustContent";

	//styles
	public static final String BROKEN_IMAGE_BORDER_SKIN = "brokenImageBorderSkin";
	public static final String BROKEN_IMAGE_SKIN = "brokenImageSkin";
	public static final String HORIZONTAL_ALIGN = "horizontalAlign";
	public static final String VERTICAL_ALIGN = "verticalAlign";

	public static final String COMPLETE_EFFECT = "completeEffect";

	//events
	public static final String COMPLETE = "complete";
	public static final String HTTP_STATUS = "httpStatus";
	public static final String INIT = "init";
	public static final String IO_ERROR = "ioError";
	public static final String OPEN = "open";
	public static final String PROGRESS = "progress";
	public static final String SECURITY_ERROR = "securityError";
	public static final String INLOAD = "unload";

	@Override
	protected void installModelProperty() {
		super.installModelProperty();

		addBooleanModelProperty(AUTO_LOAD, CATEGORY_PROPERTY, true);
		addStringModelProperty(LOADER_CONTENT, CATEGORY_PROPERTY);
		addBooleanModelProperty(MAINTAIN_ASPECT_RATIO, CATEGORY_PROPERTY, true);
		addBooleanModelProperty(SCALE_CONTENT, CATEGORY_PROPERTY, false);
		addStringModelProperty(SOURCE, CATEGORY_PROPERTY);
		addBooleanModelProperty(TRUST_CONTENT, CATEGORY_PROPERTY, false);

		addStringModelProperty(BROKEN_IMAGE_BORDER_SKIN, CATEGORY_STYLE);
		addStringModelProperty(BROKEN_IMAGE_SKIN, CATEGORY_STYLE);
		addListModelProperty(HORIZONTAL_ALIGN, CATEGORY_STYLE, new String[] { "left", "center", "right" });
		addListModelProperty(VERTICAL_ALIGN, CATEGORY_STYLE, new String[] { "top", "middle", "bottom" });

		addStringModelProperty(COMPLETE_EFFECT, CATEGORY_EFFECT);

		addStringModelProperty(COMPLETE, CATEGORY_EVENT);
		addStringModelProperty(HTTP_STATUS, CATEGORY_EVENT);
		addStringModelProperty(INIT, CATEGORY_EVENT);
		addStringModelProperty(IO_ERROR, CATEGORY_EVENT);
		addStringModelProperty(OPEN, CATEGORY_EVENT);
		addStringModelProperty(PROGRESS, CATEGORY_EVENT);
		addStringModelProperty(SECURITY_ERROR, CATEGORY_EVENT);
		addStringModelProperty(INLOAD, CATEGORY_EVENT);
	}

	@Override
	protected String getComponentName() {
		return COMPONENT_NAME;
	}

	@Override
	public String getFlexModelPackageName() {
		return PACKAGE_NAME;
	}

	public int getDefaultHeight() {
		return DEFAULT_HEIGHT;
	}

	public int getDefaultWidth() {
		return DEFAULT_WIDTH;
	}
}
