package net.sf.amateras.air.mxml.models;

import net.sf.amateras.air.util.ColorUtil;

/**
 * Model of mx.controls.VideoDisplay
 * @author ogawahideko
 *
 */
public class VideoDisplayModel extends AbstractComponentModel {
	private static final int DEFAULT_WIDTH = 50;
	private static final int DEFAULT_HEIGHT = 50;
	private static final double VOLUME_DEFAULT_VALUE = 0.75;
	private static final int PROCESS_INTERVAL_DEFAULT_VALUE = 250;
	private static final int PLAYHEAD_UPDATE_INTERVAL_DEFAULT_VALUE = 250;
	private static final int IDLE_TIMEOUT_DEFAULT_VALUE = 300000;
	private static final double BUFFER_TIME_DEFAULT_VALUE = 0.1;
	public static final String PACKAGE_NAME = "mx.controls";
	public static final String COMPONENT_NAME = "VideoDisplay";

	//properties
	public static final String AUTO_BAND_WIDTH_DETECTION = "autoBandWidthDetection";
	public static final String AUTO_PLAY = "autoPlay";
	public static final String AUTO_REWIND = "autoRewind";
	public static final String BUFFER_TIME = "bufferTime";
	public static final String CUE_POINT_MANAGER_CLASS = "cuePointManagerClass";
	public static final String CUE_POINTS = "cuePoints";
	public static final String IDLE_TIMEOUT = "idleTimeout";
	public static final String LIVE = "live";
	public static final String MAINTAIN_ASPECT_RATIO = "maintainAspectRatio";
	public static final String PLAYHEAD_TIME = "playheadTime";
	public static final String PLAYHEAD_UPDATE_INTERVAL = "playheadUpdateInterval";
	public static final String PROCESS_INTERVAL = "progressInterval";
	public static final String SOURCE = "source";
	public static final String TOTAL_TIME = "totalTime";
	public static final String VOLUME = "volume";

	//styles
	public static final String BACKGROUND_ALPHA = "backgroundAlpha";
	public static final String BACKGROUND_COLOR = "backgroundColor";
	public static final String BACKGROUND_IMAGE = "backgroundImage";
	public static final String BACKGROUND_SIZE = "backgroundSize";
	public static final String BORDER_COLOR = "borderColor";
	public static final String BORDER_SIDES = "borderSides";
	public static final String BORDER_SKIN = "borderSkin";
	public static final String BORDER_STYLE = "borderStyle";
	public static final String BORDER_THICKNESS = "borderThickness";
	public static final String CORNER_RADIUS = "cornerRadius";
	public static final String DROP_SHADOW_COLOR = "dropShadowColor";
	public static final String DROP_SHADOW_ENABLED = "dropShadowEnabled";
	public static final String SHADOW_DIRECTION = "shadowDirection";
	public static final String SHADOW_DISTANCE = "shadowDistance";

	//events
	public static final String CLOSE = "close";
	public static final String COMPLETE = "complete";
	public static final String CUE_POINT = "cuePoint";
	public static final String PLAYHEAD_UPDATE = "playheadUpdate";
	public static final String PROGRESS = "progress";
	public static final String READY = "ready";
	public static final String REWIND = "rewind";
	public static final String STATE_CHANGE = "stateChange";

	@Override
	protected void installModelProperty() {
		super.installModelProperty();
		addBooleanModelProperty(AUTO_BAND_WIDTH_DETECTION, CATEGORY_PROPERTY, false);
		addBooleanModelProperty(AUTO_PLAY, CATEGORY_PROPERTY, true);
		addBooleanModelProperty(AUTO_REWIND, CATEGORY_PROPERTY, true);
		addDoubleModelProperty(BUFFER_TIME, CATEGORY_PROPERTY, BUFFER_TIME_DEFAULT_VALUE);
		addStringModelProperty(CUE_POINT_MANAGER_CLASS, CATEGORY_PROPERTY);
		addStringModelProperty(CUE_POINTS, CATEGORY_PROPERTY);
		addNumberModelProperty(IDLE_TIMEOUT, CATEGORY_PROPERTY, IDLE_TIMEOUT_DEFAULT_VALUE);
		addBooleanModelProperty(LIVE, CATEGORY_PROPERTY, false);
		addBooleanModelProperty(MAINTAIN_ASPECT_RATIO, CATEGORY_PROPERTY, true);
		addDoubleModelProperty(PLAYHEAD_TIME, CATEGORY_PROPERTY, null);
		addNumberModelProperty(PLAYHEAD_UPDATE_INTERVAL, CATEGORY_PROPERTY, PLAYHEAD_UPDATE_INTERVAL_DEFAULT_VALUE);
		addNumberModelProperty(PROCESS_INTERVAL, CATEGORY_PROPERTY, PROCESS_INTERVAL_DEFAULT_VALUE);
		addStringModelProperty(SOURCE, CATEGORY_PROPERTY);
		addDoubleModelProperty(TOTAL_TIME, CATEGORY_PROPERTY, null);
		addDoubleModelProperty(VOLUME, CATEGORY_PROPERTY, VOLUME_DEFAULT_VALUE);

		addDoubleModelProperty(BACKGROUND_ALPHA, CATEGORY_STYLE, 1.0);
		addColorModelProperty(BACKGROUND_COLOR, CATEGORY_STYLE, ColorUtil.toRGB("#000000"));
		addImageModelProperty(BACKGROUND_IMAGE, CATEGORY_STYLE);
		addWidthHeightModelProperty(BACKGROUND_SIZE, CATEGORY_STYLE, "");
		addColorModelProperty(BORDER_COLOR, CATEGORY_STYLE);
		addStringModelProperty(BORDER_SIDES, CATEGORY_STYLE, "left top right bottom");
		addStringModelProperty(BORDER_SKIN, CATEGORY_STYLE);
		addStringModelProperty(BORDER_STYLE, CATEGORY_STYLE);
		addDoubleModelProperty(BORDER_THICKNESS, CATEGORY_STYLE, Double.valueOf(1));
		addDoubleModelProperty(CORNER_RADIUS, CATEGORY_STYLE, Double.valueOf(0));
		addColorModelProperty(DROP_SHADOW_COLOR, CATEGORY_STYLE, ColorUtil.toRGB("#000000"));
		addBooleanModelProperty(DROP_SHADOW_ENABLED, CATEGORY_STYLE, false);
		addListModelProperty(SHADOW_DIRECTION, CATEGORY_STYLE, LIST_LEFT_RIGHT_CENTER, "center");
		addDoubleModelProperty(SHADOW_DISTANCE, CATEGORY_STYLE, Double.valueOf(2));

		addStringModelProperty(CLOSE, CATEGORY_EVENT);
		addStringModelProperty(COMPLETE, CATEGORY_EVENT);
		addStringModelProperty(CUE_POINT, CATEGORY_EVENT);
		addStringModelProperty(PLAYHEAD_UPDATE, CATEGORY_EVENT);
		addStringModelProperty(PROGRESS, CATEGORY_EVENT);
		addStringModelProperty(READY, CATEGORY_EVENT);
		addStringModelProperty(REWIND, CATEGORY_EVENT);
		addStringModelProperty(STATE_CHANGE, CATEGORY_EVENT);

	}

	@Override
	protected String getComponentName() {
		return COMPONENT_NAME;
	}

	@Override
	public String getFlexModelPackageName() {
		return PACKAGE_NAME;
	}

	public int getDefaultHeight() {
		return DEFAULT_HEIGHT;
	}

	public int getDefaultWidth() {
		return DEFAULT_WIDTH;
	}
}
