package net.sf.amateras.air.preferences;

import net.sf.amateras.air.AIRPlugin;

import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.swt.graphics.RGB;

/**
 * Initializes preferences.
 * 
 * @author Naoki Takezoe
 */
public class AIRPreferenceInitializer extends AbstractPreferenceInitializer {

	private static final int PREF_FONT_MATTING_SIZE = -2;
	private static final int BLUE128 = 128;
	private static final int RED128 = 128;
	private static final int BLUE255 = 255;
	private static final int GREEN128 = 128;

	@Override
	public void initializeDefaultPreferences() {
		IPreferenceStore store = AIRPlugin.getDefault().getPreferenceStore();
		store.setDefault(AIRPlugin.PREF_AIR_SDK_PATH, "");
		store.setDefault(AIRPlugin.PREF_FLEX_SDK_PATH, "");
		store.setDefault(AIRPlugin.PREF_DESCRIPTOR, "application.xml");
		store.setDefault(AIRPlugin.PREF_FLEX_LIBRARIES, "");
		store.setDefault(AIRPlugin.PREF_COLOR_DEFAULT, StringConverter.asString(new RGB(0, 0, 0)));
		store.setDefault(AIRPlugin.PREF_COLOR_COMMENT, StringConverter.asString(new RGB(0, GREEN128, 0)));
		store.setDefault(AIRPlugin.PREF_COLOR_STRING, StringConverter.asString(new RGB(0, 0, BLUE255)));
		store.setDefault(AIRPlugin.PREF_COLOR_KEYWORD, StringConverter.asString(new RGB(RED128, 0, BLUE128)));

		store.setDefault(AIRPlugin.PREF_AIR_COMPILE_COMMAND, "mxmlc");
		store.setDefault(AIRPlugin.PREF_AIR_COMPILE_OPTION, "+configname=air ${DIRECTORY}${PROJECT_NAME}.mxml "
				+ "-output ${PROJECT_NAME}.swf -library-path+=${LIBRARY_PATH} ");
		store.setDefault(AIRPlugin.PREF_AS3_COMPILE_COMMAND, "compc");
		store.setDefault(AIRPlugin.PREF_AS3_COMPILE_OPTION, "-output bin/${PROJECT_NAME}.swc"
				+ " -source-path ${DIRECTORY} -include-classes ${AS_FILES} -library-path+=${LIBRARY_PATH} ");
		store.setDefault(AIRPlugin.PREF_FLEX3_COMPILE_COMMAND, "mxmlc");
		store.setDefault(AIRPlugin.PREF_FLEX3_COMPILE_OPTION, "${DIRECTORY}${PROJECT_NAME}.as "
				+ " -output ${PROJECT_NAME}.swf -library-path+=${LIBRARY_PATH} ");

		store.setDefault(AIRPlugin.PREF_FLEX_COMPILES, "\tmxmlc\t"
				+ store.getDefaultString(AIRPlugin.PREF_AIR_COMPILE_OPTION) + "\t1\tfalse");
		String osName = System.getProperty("os.name");
		boolean isWindows = osName.indexOf("Windows") >= 0;

		if (isWindows) {
			store.setDefault(AIRPlugin.PREF_FCSH_SHELL_COMMAND, "bin/fcsh.exe");
			store.setDefault(AIRPlugin.PREF_ADL_COMMAND, "bin/adl.exe");
			store.setDefault(AIRPlugin.PREF_ADT_COMMAND, "bin/adt.bat");
			store.setDefault(AIRPlugin.PREF_FDB_COMMAND, "bin/fdb.exe");
			store.setValue(AIRPlugin.PREF_FONT_MATTING_SIZE, PREF_FONT_MATTING_SIZE);
		} else {
			store.setDefault(AIRPlugin.PREF_FCSH_SHELL_COMMAND, "bin/fcsh");
			store.setDefault(AIRPlugin.PREF_ADL_COMMAND, "bin/adl");
			store.setDefault(AIRPlugin.PREF_ADT_COMMAND, "bin/adt");
			store.setDefault(AIRPlugin.PREF_FDB_COMMAND, "bin/fdb");
			store.setValue(AIRPlugin.PREF_FONT_MATTING_SIZE, 0);
		}

		store
				.setDefault(AIRPlugin.PREF_COMPILE_MESSAGE_PATTERN, AIRPlugin
						.getResourceString("COMPILE_MESSAGE_PATTERN"));
		store.setDefault(AIRPlugin.PREF_COMPILE_FAIL_PATTERN, AIRPlugin.getResourceString("COMPILE_FAIL_PATTERN"));
		store.setDefault(AIRPlugin.PREF_COMPILE_ERROR_PATTERN, AIRPlugin.getResourceString("COMPILE_ERROR_PATTERN"));
		store
				.setDefault(AIRPlugin.PREF_COMPILE_WARNING_PATTERN, AIRPlugin
						.getResourceString("COMPILE_WARNING_PATTERN"));

		store.setDefault(AIRPlugin.PREF_COMPILE_FAIL_PATTERN_2, AIRPlugin.getResourceString("COMPILE_FAIL_PATTERN_2"));
		store
				.setDefault(AIRPlugin.PREF_COMPILE_ERROR_PATTERN_2, AIRPlugin
						.getResourceString("COMPILE_ERROR_PATTERN_2"));
		store.setDefault(AIRPlugin.PREF_COMPILE_WARNING_PATTERN_2, AIRPlugin
				.getResourceString("COMPILE_WARNING_PATTERN_2"));
		store.setDefault(AIRPlugin.PREF_COMPILE_TARGET_NOT_FOUND_PATTERN, AIRPlugin
				.getResourceString("COMPILE_TARGET_NOT_FOUND"));

		store.setDefault(AIRPlugin.PREF_FORMATTER_TAB_POLICY, FormatPropertyPage.TAB_POLICY_TABS_ONLY);
		store.setDefault(AIRPlugin.PREF_FORMATTER_SPACE_INDENT_SIZE, 4);
		store.setDefault(AIRPlugin.PREF_FORMATTER_BRACE, FormatPropertyPage.BRACE_SAME_LINE);

		// ActionScript3 syntax analisys
		StringBuilder sb = new StringBuilder();
		sb.append("${FLEX_SDK_PATH}/frameworks/projects/framework/src").append("\t");
		sb.append("${FLEX_SDK_PATH}/frameworks/projects/airframework/src").append("\t");
		sb.append("${FLEX_SDK_PATH}/frameworks/projects/flex/src").append("\t");
		sb.append("${FLEX_SDK_PATH}/frameworks/projects/haloclassic/src").append("\t");
		sb.append("${FLEX_SDK_PATH}/frameworks/projects/rpc/src").append("\t");
		sb.append("${FLEX_SDK_PATH}/frameworks/projects/utilities/src");
		store.setDefault(AIRPlugin.PREF_SDK_SOURCES, sb.toString());

		store.setDefault(AIRPlugin.PREF_AS3_IS_PARSE_ENABLED, false);
		store.setDefault(AIRPlugin.PREF_AS3_IS_SHOW_OUTLINE_ENABLED, false);
		store.setDefault(AIRPlugin.PREF_AS3_IS_CONTENT_ASSIST_MXML_ENABLED, false);
		store.setDefault(AIRPlugin.PREF_AS3_IS_CONTENT_ASSIST_FLEX_ENABLED, false);

	}

}
