package net.sf.amateras.air.preferences;

import net.sf.amateras.air.AIRPlugin;
import net.sf.amateras.air.util.UIUtil;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

/**
 * The property page for the Format.
 * 
 * @author ogawahideko
 */

public class FormatPropertyPage extends PreferencePage implements IWorkbenchPreferencePage {
	public static final int TAB_POLICY_TABS_ONLY = 0;
	public static final int TAB_POLICY_SPACES_ONLY = 1;

	public static final int BRACE_SAME_LINE = 0;
	public static final int BRACE_NEXT_LINE = 1;

	private Combo tabPolicy;
	private Spinner spaceIndentSize;

	//private Combo bracePosition;

	public FormatPropertyPage() {
		super(AIRPlugin.getResourceString("FORMAT"));
		setPreferenceStore(AIRPlugin.getDefault().getPreferenceStore());
	}

	public void init(IWorkbench workbench) {

	}

	@Override
	protected Control createContents(Composite parent) {
		IPreferenceStore store = getPreferenceStore();

		Composite composite = new Composite(parent, SWT.NULL);
		composite.setLayout(new GridLayout(1, false));
		composite.setLayoutData(new GridData(GridData.FILL_BOTH));

		Group indent = new Group(composite, SWT.BORDER);
		indent.setLayout(new GridLayout(2, false));
		indent.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		indent.setText(AIRPlugin.getResourceString("INDENTATION"));

		UIUtil.createLabel(AIRPlugin.getResourceString("TAB_POLICY"), indent);
		tabPolicy = new Combo(indent, SWT.DROP_DOWN | SWT.READ_ONLY);
		tabPolicy.add(AIRPlugin.getResourceString("TAB_ONLY"));
		tabPolicy.add(AIRPlugin.getResourceString("SPACE_ONLY"));
		tabPolicy.select(store.getInt(AIRPlugin.PREF_FORMATTER_TAB_POLICY));

		UIUtil.createLabel(AIRPlugin.getResourceString("SPACE_INDENTATION_SIZE"), indent);
		spaceIndentSize = new Spinner(indent, SWT.NULL);
		spaceIndentSize.setMinimum(0);
		spaceIndentSize.setMaximum(10);
		spaceIndentSize.setSelection(store.getInt(AIRPlugin.PREF_FORMATTER_SPACE_INDENT_SIZE));

		//		Group braces = new Group(composite, SWT.BORDER);
		//		braces.setLayout(new GridLayout(2, false));
		//		braces.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		//		braces.setText("Braces");
		//
		//		UIUtil.createLabel("Brace position", braces);
		//		bracePosition = new Combo(braces, SWT.DROP_DOWN | SWT.READ_ONLY);
		//		bracePosition.add("Same line");
		//		bracePosition.add("Next line");
		//		bracePosition.select(store.getInt(AIRPlugin.PREF_FORMATTER_BRACE));
		//		bracePosition.select(store.getInt(AIRPlugin.PREF_FORMATTER_BRACE));
		return composite;
	}

	@Override
	public boolean performOk() {
		IPreferenceStore store = getPreferenceStore();
		store.setValue(AIRPlugin.PREF_FORMATTER_TAB_POLICY, tabPolicy.getSelectionIndex());
		store.setValue(AIRPlugin.PREF_FORMATTER_SPACE_INDENT_SIZE, spaceIndentSize.getSelection());
		//store.setValue(AIRPlugin.PREF_FORMATTER_BRACE, bracePosition.getSelectionIndex());
		return super.performOk();
	}

	@Override
	protected void performDefaults() {
		IPreferenceStore store = getPreferenceStore();
		store.setValue(AIRPlugin.PREF_FORMATTER_TAB_POLICY, store.getDefaultInt(AIRPlugin.PREF_FORMATTER_TAB_POLICY));
		store.setValue(AIRPlugin.PREF_FORMATTER_SPACE_INDENT_SIZE, store
				.getDefaultInt(AIRPlugin.PREF_FORMATTER_SPACE_INDENT_SIZE));
		//store.setValue(AIRPlugin.PREF_FORMATTER_BRACE, store.getDefaultInt(AIRPlugin.PREF_FORMATTER_BRACE));
		super.performDefaults();
	}

}
