package net.sf.amateras.air.propertyPages;

import net.sf.amateras.air.AIRPlugin;
import net.sf.amateras.air.natures.AIRFlexProjectNature;
import net.sf.amateras.air.util.UIUtil;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

/**
 * The property page for the AIR project.
 * 
 * @author Naoki Takezoe
 */
public class AIRPropertyPage extends PropertyPage implements IWorkbenchPropertyPage {

	private Text descriptor;

	private IProject getProject() {
		IAdaptable adaptable = getElement();
		if (adaptable instanceof IProject) {
			return (IProject) adaptable;
		}
		return (IProject) adaptable.getAdapter(IProject.class);
	}

	@Override
	protected Control createContents(Composite parent) {
		setTitle("AIR GEAR");
		ScopedPreferenceStore store = new ScopedPreferenceStore(new ProjectScope(getProject()), AIRPlugin.PLUGIN_ID);
		setPreferenceStore(store);

		Composite composite = createComposite(parent, 1);

		//descriptor
		Composite descriptorGroup = createComposite(composite, 2);
		UIUtil.createLabel("Application Descriptor", descriptorGroup);
		descriptor = createText(descriptorGroup, store.getString(AIRPlugin.PREF_DESCRIPTOR));
		addExistCheck(descriptor, AIRPlugin.getResourceString("APPLICATION_DESCRIPTOR_SPEC"));

		try {
			if (getProject().getNature(AIRFlexProjectNature.NATURE_ID) == null) {
				return composite;
			}
		} catch (CoreException e) {
			e.printStackTrace();
			return composite;
		}

		return composite;
	}

	private Composite createComposite(Composite parent, int column) {
		Composite group = new Composite(parent, SWT.NULL);
		group.setLayout(new GridLayout(column, false));
		group.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		return group;
	}

	private Text createText(Composite parent, String label) {
		Text text = new Text(parent, SWT.BORDER);
		text.setText(label);
		text.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		return text;
	}

	private void addExistCheck(final Text text, final String errorMessage) {
		text.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				if (text.getText().length() == 0) {
					setErrorMessage(errorMessage);
					setValid(false);
				} else {
					setErrorMessage(null);
					setValid(true);
				}
			}
		});
	}

	@Override
	protected void performDefaults() {
		IPreferenceStore store = getPreferenceStore();
		if (descriptor != null) {
			descriptor.setText(store.getDefaultString(AIRPlugin.PREF_DESCRIPTOR));
		}
	}

	@Override
	public boolean performOk() {
		IPreferenceStore store = getPreferenceStore();
		if (descriptor != null) {
			store.setValue(AIRPlugin.PREF_DESCRIPTOR, descriptor.getText());
		}
		return true;
	}

}
