package net.sf.amateras.air.util;

import java.util.HashMap;
import java.util.Map;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.swt.graphics.RGB;

public class ColorUtil {

	private ColorUtil() {
	}

	private static final Map<String, RGB> COLORS = new HashMap<String, RGB>();
	static {
		COLORS.put("white", ColorConstants.white.getRGB());
		COLORS.put("lightGray", ColorConstants.lightGray.getRGB());
		COLORS.put("gray", ColorConstants.gray.getRGB());
		COLORS.put("darkGray", ColorConstants.darkGray.getRGB());
		COLORS.put("black", ColorConstants.black.getRGB());
		COLORS.put("red", ColorConstants.red.getRGB());
		COLORS.put("orange", ColorConstants.orange.getRGB());
		COLORS.put("yellow", ColorConstants.yellow.getRGB());
		COLORS.put("green", ColorConstants.green.getRGB());
		COLORS.put("lightGreen", ColorConstants.lightGreen.getRGB());
		COLORS.put("darkGreen", ColorConstants.darkGreen.getRGB());
		COLORS.put("cyan", ColorConstants.cyan.getRGB());
		COLORS.put("lightBlue", ColorConstants.lightBlue.getRGB());
		COLORS.put("blue", ColorConstants.blue.getRGB());
		COLORS.put("darkBlue", ColorConstants.darkBlue.getRGB());
	}

	/**
	 * Converts {@link RGB} to the hex string.
	 * 
	 * @param color the RGB object
	 * @return the hex string
	 */
	public static String toHex(RGB color) {
		StringBuffer sb = new StringBuffer();
		sb.append("#").append(toHex(color.red)).append(toHex(color.green)).append(toHex(color.blue));
		return sb.toString();
	}

	private static String toHex(int value) {
		String hex = Integer.toHexString(value);
		if (hex.length() == 1) {
			hex = "0" + hex;
		}
		return hex;
	}

	/**
	 * Converts the hex string to {@link RGB}.
	 * 
	 * @param value the hex string
	 * @return {@link RGB}
	 */
	public static RGB toRGB(String value) {
		if (value.startsWith("#")) {
			String red = value.substring(1, 3);
			String green = value.substring(3, 5);
			String blue = value.substring(5, 7);
			return new RGB(toDecimal(red), toDecimal(green), toDecimal(blue));
		} else {
			return COLORS.get(value.toLowerCase());
		}
	}

	private static int toDecimal(String value) {
		int result = 0;
		int count = 1;
		for (int i = value.length() - 1; i >= 0; i--) {
			char c = value.charAt(i);
			if (c >= '0' && c <= '9') {
				result += Integer.parseInt(String.valueOf(c)) * count;
			} else if (c >= 'a' && c <= 'f') {
				result += (c - 'a' + 10) * count;
			} else if (c >= 'A' && c <= 'F') {
				result += (c - 'A' + 10) * count;
			}
			count = count * 16;
		}
		return result;
	}

	public static boolean isBlack(RGB color) {
		if (color == null) {
			return true;
		}
		return color.red == 0 && color.blue == 0 && color.green == 0;
	}
}
