package net.sf.amateras.air.util;

import net.sf.amateras.air.AIRPlugin;

import org.eclipse.jface.preference.IPreferenceStore;

public class SDKSourcesUtil {

	private SDKSourcesUtil() {
		// no instance.
	}

	public static String[] getSDKSources() {
		IPreferenceStore store = AIRPlugin.getDefault().getPreferenceStore();
		String sources = store.getString(AIRPlugin.PREF_SDK_SOURCES);
		return sources.split("\t");
	}

	public static String[] getParsedSDKSources() {
		IPreferenceStore store = AIRPlugin.getDefault().getPreferenceStore();
		String sdkPath = store.getString(AIRPlugin.PREF_FLEX_SDK_PATH);
		String sources = store.getString(AIRPlugin.PREF_SDK_SOURCES);

		sources = sources.replaceAll("\\$\\{FLEX_SDK_PATH\\}", sdkPath);
		sources = sources.replaceAll("\\$\\{AIR_SDK_PATH\\}", sdkPath);
		return sources.split("\t");
	}

}
