package net.sf.amateras.air.wizards;

import net.sf.amateras.air.util.ReflectionUtil;

import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;

/**
 * The wizard page to input AIR project name.
 * 
 * @author Naoki Takezoe
 */
public abstract class AbstractProjectWizardPage extends WizardNewProjectCreationPage {

	/**
	 * Constructor.
	 * 
	 * @param pageName the page name
	 * @param projectType {@link AbstractProjectWizardPage#HTML_PROJECT} or 
	 *     {@link AbstractProjectWizardPage#FLEX_PROJECT}
	 */
	public AbstractProjectWizardPage(String pageName) {
		super(pageName);
	}

	@Override
	public void createControl(Composite parent) {
		super.createControl(parent);

		Text text = (Text) ReflectionUtil.getField(this, "projectNameField");
		text.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent evt) {
				modifyTextToProjetName();
			}
		});

		validatePage();
	}

	protected abstract void modifyTextToProjetName();

}
