package net.sf.amateras.air.wizards.export;

import java.util.List;

import net.sf.amateras.air.AIRPlugin;
import net.sf.amateras.air.launch.LaunchADTConfiguration;
import net.sf.amateras.air.util.ProcessUtil;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.jface.preference.IPreferenceStore;

/**
 * Launch <tt>adt.bat</tt> to export resources as the AIR package.
 * 
 * @author Naoki Takezoe
 */
@SuppressWarnings("restriction")
public class ADTRunner {

	/**
	 * Launch <tt>adt.bat</tt> to export resources as the AIR package.
	 * <p>
	 * <strong>Note:</strong> This method should be called on the UI thread.
	 * 
	 * @param project AIR project
	 * @param option package options
	 * @param exportResources export resources
	 */
	public boolean run(IProject project, List<String> option, List<IResource> exportResources) {
		if (exportResources != null) {
			for (int i = 0; i < exportResources.size(); i++) {
				IResource resource = exportResources.get(i);
				option.add(resource.getProjectRelativePath().toOSString());
			}
		}
		return run(project, option);
	}

	/**
	 * Exectute adt
	 * <p>
	 * need PreferenceStore FLEX_SDK_PATH or AIR_SDK_Path.
	 * </p>
	 * @param project
	 * @param option
	 * @return
	 */
	public boolean run(IProject project, List<String> option) {
		IPreferenceStore store = AIRPlugin.getDefault().getPreferenceStore();
		if (project == null || !ProcessUtil.checkAirGearProject(project)) {
			return false;
		}
		String adtPath = store.getString(AIRPlugin.PREF_ADT_COMMAND);
		String sdkPath = ProcessUtil.getAirSdkPath(adtPath);
		if (sdkPath == null) {
			return false;
		}

		try {

			final ILaunchConfigurationWorkingCopy config = LaunchADTConfiguration.getADTConfiguration(project, option
					.get(0));

			config.setAttribute(LaunchADTConfiguration.KEY_PROJECT, project.getName());
			config.setAttribute(LaunchADTConfiguration.KEY_OPTIONS, option);

			//DebugUIPlugin.launchInForeground(config, ILaunchManager.RUN_MODE);
			DebugUIPlugin.launchInBackground(config, ILaunchManager.RUN_MODE);

			return true;

		} catch (Exception ex) {
			ex.printStackTrace();
			return false;

		}
	}

}
