package net.sf.amateras.air.wizards.file;

import java.util.Map;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;

/**
 * Wizard for ActionScript File creation.
 * @author ogawahideko
 *
 */
public class WizardNewASFileCreationPage extends AbstractFileCreationPage {

	public WizardNewASFileCreationPage(ISelection selection) {
		super(selection);
		setTitle("ActionScript 3 File");
		setDescription("This wizard creates a new ActionScript 3 file.");
	}

	@Override
	public void setTemplateLayout(Composite group, SelectionAdapter adapter) {
		Button button = new Button(group, SWT.RADIO);
		button.setText("&Simple");
		button.addSelectionListener(adapter);
		button = new Button(group, SWT.RADIO);
		button.setText("&Class");
		button.setSelection(true);
		button.addSelectionListener(adapter);
		button = new Button(group, SWT.RADIO);
		button.setText("&Interface");
		button.addSelectionListener(adapter);

		setTemplate("Class");
	}

	@Override
	public String getExtension() {
		return ".as";
	}

	@Override
	public Map<String, String> getParameters() {
		return null;
	}

}
