package net.sf.amateras.air.wizards.file;

import java.util.HashMap;
import java.util.Map;

import net.sf.amateras.air.AIRPlugin;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

/**
 * Page of MXML Wizard Page.
 * @author ogawahideko
 *
 */
public class WizardNewMxmlFileCreationPage extends AbstractFileCreationPage {
	private Text titleText;
	private Button includeScript;
	private Text scriptFooter;

	public WizardNewMxmlFileCreationPage(ISelection selection) {
		super(selection);
		setTitle("MXML Editor File");
		setDescription("This wizard creates a new file with *.mxml extension that can be opened by a mxml editor.");
	}

	@Override
	protected void setLayoutText(Composite container, ModifyListener modifyListener) {
		super.setLayoutText(container, modifyListener);
		Label label = new Label(container, SWT.NULL);
		label.setText("&Title:");
		titleText = new Text(container, SWT.BORDER | SWT.SINGLE);
		GridData gd = new GridData(GridData.FILL_HORIZONTAL);
		titleText.setLayoutData(gd);
		titleText.addModifyListener(modifyListener);
		new Label(container, SWT.NULL);
	}

	@Override
	protected void setLayoutOption(Composite container) {
		super.setLayoutOption(container);
		includeScript = new Button(container, SWT.CHECK);
		includeScript.setText("&Include Script");
		scriptFooter = new Text(container, SWT.BORDER | SWT.SINGLE);
		GridData gd = new GridData(GridData.FILL_HORIZONTAL);
		scriptFooter.setLayoutData(gd);
		scriptFooter.setText("Script.as");
		new Label(container, SWT.NULL);
	}

	@Override
	protected void modifyTextToFileName(String fileName) {
		super.modifyTextToFileName(fileName);
		scriptFooter.setText(fileName + "Script.as");
	}

	@Override
	public void setTemplateLayout(Composite group, SelectionAdapter adapter) {
		Button button = new Button(group, SWT.RADIO);
		button.setText("&Simple");
		button.addSelectionListener(adapter);
		button = new Button(group, SWT.RADIO);
		button.setText("&WindowedApplication");
		button.setSelection(true);
		button.addSelectionListener(adapter);
		button = new Button(group, SWT.RADIO);
		button.setText("&Application");
		button.addSelectionListener(adapter);
		button = new Button(group, SWT.RADIO);
		button.setText("&TitleWindow");
		button.addSelectionListener(adapter);
		button = new Button(group, SWT.RADIO);
		button.setText("&Window");
		button.addSelectionListener(adapter);

		setTemplate("Application");

	}

	@Override
	public String getExtension() {
		return ".mxml";
	}

	@Override
	public Map<String, String> getParameters() {
		Map<String, String> params = new HashMap<String, String>();
		params.put("title", titleText.getText());
		params.put("file_name", getFileName());
		if (includeScript.getSelection()) {
			String script = "<" + AIRPlugin.getDefault().getNameSpacePrefix() + "Script source=\""
					+ scriptFooter.getText() + "\" />";
			params.put("script", script);
			params.put("script_footer", scriptFooter.getText());
		} else {
			params.put("script", "");
		}
		return params;
	}

}
