package net.sf.amateras.air.wizards.project;

import net.sf.amateras.air.AIRPlugin;
import net.sf.amateras.air.wizards.AbstractAIRProjectPropertiesWizardPage;
import net.sf.amateras.air.wizards.AbstractProjectWizardPage;

import org.eclipse.jface.preference.IPreferenceStore;

/**
 * The wizard page to input AIR project name.
 * 
 * @author Naoki Takezoe
 */
public class AIRProjectWizardPage extends AbstractProjectWizardPage {

	public static final int HTML_PROJECT = 0;
	public static final int FLEX_PROJECT = 1;
	public static final int FLEX3_PROJECT = 3;

	private int projectType;

	/**
	 * Constructor.
	 * 
	 * @param pageName the page name
	 * @param projectType {@link AIRProjectWizardPage#HTML_PROJECT} or 
	 *     {@link AIRProjectWizardPage#FLEX_PROJECT}
	 */
	public AIRProjectWizardPage(String pageName, int projectType) {
		super(pageName);
		this.projectType = projectType;
	}

	@Override
	protected void modifyTextToProjetName() {
		AbstractAIRProjectPropertiesWizardPage nextPage = (AbstractAIRProjectPropertiesWizardPage) getNextPage();
		if (nextPage != null) {
			nextPage.projectNameChanged(getProjectName());
		}
	}

	@Override
	protected boolean validatePage() {
		IPreferenceStore store = AIRPlugin.getDefault().getPreferenceStore();
		if (projectType == HTML_PROJECT) {
			if (store.getString(AIRPlugin.PREF_AIR_SDK_PATH).length() == 0) {
				setErrorMessage(AIRPlugin.getResourceString("NOT_AIR_SDK_SETTING"));
				setPageComplete(false);
				return false;
			}
		} else if (projectType == FLEX_PROJECT || projectType == FLEX3_PROJECT) {
			if (store.getString(AIRPlugin.PREF_FLEX_SDK_PATH).length() == 0) {
				setErrorMessage(AIRPlugin.getResourceString("NOT_FLEX_SDK_SETTING"));
				setPageComplete(false);
				return false;
			}
		}
		return super.validatePage();
	}

}
