/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.amateras.functions;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import jp.sf.amateras.functions.utils.RequestUtils;
import org.apache.log4j.Logger;

public class Log4j {
    private static Map<String, String> loggerNameMap = new ConcurrentHashMap<String, String>();

    protected static String getLoggerName(String servletPath) {
        if (loggerNameMap.containsKey(servletPath)) {
            return loggerNameMap.get(servletPath);
        }
        String path = servletPath;
        String loggerName = "";
        if (path.endsWith(".jsp")) {
            loggerName = "jsp.";
            path = path.replaceFirst("\\.jsp$", "");
        }
        if ((path = path.replace('/', '.')).startsWith(".")) {
            path = path.substring(1);
        }
        loggerName = String.valueOf(loggerName) + path;
        loggerNameMap.put(servletPath, loggerName);
        return loggerName;
    }

    protected static Logger getLogger() {
        HttpServletRequest request = RequestUtils.getRequest();
        return Logger.getLogger((String)Log4j.getLoggerName(request.getServletPath()));
    }

    public static void trace(Object message) {
        Log4j.getLogger().trace(message);
    }

    public static void debug(Object message) {
        Log4j.getLogger().debug(message);
    }

    public static void info(Object message) {
        Log4j.getLogger().info(message);
    }

    public static void warn(Object message) {
        Log4j.getLogger().warn(message);
    }

    public static void error(Object message) {
        Log4j.getLogger().error(message);
    }

    public static void fatal(Object message) {
        Log4j.getLogger().fatal(message);
    }
}

