/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.amateras.functions.utils;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringUtils {
    private static final int HIGHEST_SPECIAL = 62;
    private static String BR = "<br />";
    private static String NBSP = "&nbsp;";
    private static char[][] specialCharactersRepresentation = new char[63][];
    private static String defaultEncoding;

    static {
        StringUtils.specialCharactersRepresentation[38] = "&amp;".toCharArray();
        StringUtils.specialCharactersRepresentation[60] = "&lt;".toCharArray();
        StringUtils.specialCharactersRepresentation[62] = "&gt;".toCharArray();
        StringUtils.specialCharactersRepresentation[34] = "&#034;".toCharArray();
        StringUtils.specialCharactersRepresentation[39] = "&#039;".toCharArray();
        defaultEncoding = "UTF-8";
    }

    public static void setDefaultEncoding(String defaultEncoding) {
        if (defaultEncoding != null && defaultEncoding.length() != 0) {
            StringUtils.defaultEncoding = defaultEncoding;
        }
    }

    public static String escapeHtml(String buffer) {
        if (buffer == null) {
            return "";
        }
        int start = 0;
        int length = buffer.length();
        char[] arrayBuffer = buffer.toCharArray();
        StringBuilder escapedBuffer = null;
        int i = 0;
        while (i < length) {
            char[] escaped;
            char c = arrayBuffer[i];
            if (c <= '>' && (escaped = specialCharactersRepresentation[c]) != null) {
                if (start == 0) {
                    escapedBuffer = new StringBuilder(length + 5);
                }
                if (start < i) {
                    escapedBuffer.append(arrayBuffer, start, i - start);
                }
                start = i + 1;
                escapedBuffer.append(escaped);
            }
            ++i;
        }
        if (start == 0) {
            return buffer;
        }
        if (start < length) {
            escapedBuffer.append(arrayBuffer, start, length - start);
        }
        return escapedBuffer.toString();
    }

    public static String urlEncode(String value) {
        return StringUtils.urlEncode(value, defaultEncoding);
    }

    public static String urlEncode(String value, String encode) {
        if (value == null) {
            return "";
        }
        try {
            return URLEncoder.encode(value, encode);
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static String convertLineSeparator(String value) {
        if (value == null) {
            return "";
        }
        value = value.replace("\r\n", BR);
        value = value.replace("\r", BR);
        value = value.replace("\n", BR);
        return value;
    }

    public static String convertWhitespace(String value) {
        if (value == null) {
            return "";
        }
        value = value.replace("\t", "    ");
        StringBuilder sb = new StringBuilder();
        boolean flag = true;
        int i = 0;
        while (i < value.length()) {
            char c = value.charAt(i);
            if (c == ' ') {
                if (flag) {
                    sb.append(c);
                    flag = false;
                } else {
                    sb.append(NBSP);
                }
            } else {
                sb.append(c);
                flag = true;
            }
            ++i;
        }
        return sb.toString();
    }

    public static String mask(String value, char maskChar) {
        if (value == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < value.length()) {
            sb.append(maskChar);
            ++i;
        }
        return sb.toString();
    }

    public static String cut(String value, int length) {
        if (value == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < value.length()) {
            if (i >= length) break;
            sb.append(value.charAt(i));
            ++i;
        }
        return sb.toString();
    }

    public static String convertURL(String value) {
        if (value == null) {
            return "";
        }
        return value.replaceAll("(http|https)://[A-Za-z0-9\\._~/:\\-?&=%;]+", "<a href=\"$0\">$0</a>");
    }

    public static String map2queryString(Map<String, Object> map) {
        return StringUtils.map2queryString(map, defaultEncoding);
    }

    public static String map2queryString(Map<String, Object> map, String encoding) {
        if (map == null || map.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof List) {
                for (Object item : (List)value) {
                    StringUtils.appendQueryParameter(sb, key, item, encoding);
                }
                continue;
            }
            if (value.getClass().isArray()) {
                Object[] objectArray = (Object[])value;
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object item;
                    item = objectArray[n2];
                    StringUtils.appendQueryParameter(sb, key, item, encoding);
                    ++n2;
                }
                continue;
            }
            StringUtils.appendQueryParameter(sb, key, value, encoding);
        }
        return sb.toString();
    }

    private static void appendQueryParameter(StringBuilder sb, String key, Object value, String encoding) {
        if (sb.length() != 0) {
            sb.append("&");
        }
        sb.append(key);
        sb.append("=");
        sb.append(StringUtils.urlEncode(value.toString(), encoding));
    }

    public static String escapeJavaScript(String value) {
        if (value == null) {
            return "";
        }
        StringBuilder ap = new StringBuilder();
        int i = 0;
        while (i < value.length()) {
            char c = value.charAt(i);
            switch (c) {
                case '\'': 
                case '\\': {
                    ap.append('\\').append(c);
                    break;
                }
                case '\b': {
                    ap.append("\\b");
                    break;
                }
                case '\f': {
                    ap.append("\\f");
                    break;
                }
                case '\n': {
                    ap.append("\\n");
                    break;
                }
                case '\r': {
                    ap.append("\\r");
                    break;
                }
                case '\t': {
                    ap.append("\\t");
                    break;
                }
                default: {
                    ap.append(c);
                }
            }
            ++i;
        }
        return ap.toString();
    }

    public static String concat(Object value1, Object value2) {
        if (value1 == null) {
            value1 = "";
        }
        if (value2 == null) {
            value2 = "";
        }
        return String.valueOf(value1.toString()) + value2.toString();
    }
}

