/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.amateras.mirage.bean;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import jp.sf.amateras.mirage.bean.BeanDesc;
import jp.sf.amateras.mirage.bean.PropertyDesc;
import jp.sf.amateras.mirage.bean.PropertyDescImpl;

public class BeanDescImpl
implements BeanDesc {
    private Class<?> clazz;
    private Map<String, PropertyDesc> propertyMap = new ConcurrentHashMap<String, PropertyDesc>();
    private PropertyDesc[] propertyArray;

    public BeanDescImpl(Class<?> clazz) {
        Field[] fields;
        Method[] methods;
        this.clazz = clazz;
        ArrayList<PropertyDescImpl> list = new ArrayList<PropertyDescImpl>();
        HashMap<String, PropertyInfo> map = new HashMap<String, PropertyInfo>();
        Method[] methodArray = methods = clazz.getMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (method.getDeclaringClass() != Object.class) {
                PropertyInfo info;
                String propertyName;
                String methodName = method.getName();
                if ((methodName.startsWith("get") || methodName.startsWith("is")) && method.getParameterTypes().length == 0) {
                    propertyName = BeanDescImpl.getProperyName(methodName);
                    info = (PropertyInfo)map.get(propertyName);
                    if (info == null) {
                        info = new PropertyInfo();
                        info.name = propertyName;
                        info.getterMethod = method;
                        info.type = method.getReturnType();
                        map.put(propertyName, info);
                    } else if (info.type == method.getReturnType()) {
                        info.getterMethod = method;
                    }
                }
                if (methodName.startsWith("set") && method.getParameterTypes().length == 1) {
                    propertyName = BeanDescImpl.getProperyName(methodName);
                    info = (PropertyInfo)map.get(propertyName);
                    if (info == null) {
                        info = new PropertyInfo();
                        info.name = propertyName;
                        info.setterMethod = method;
                        info.type = method.getParameterTypes()[0];
                        map.put(propertyName, info);
                    } else if (info.type == method.getParameterTypes()[0]) {
                        info.setterMethod = method;
                    }
                }
            }
            ++n2;
        }
        for (PropertyInfo info : map.values()) {
            PropertyDescImpl pd = new PropertyDescImpl(this, info.name, info.type, null, info.getterMethod, info.setterMethod);
            list.add(pd);
            this.propertyMap.put(pd.getPropertyName(), pd);
        }
        Field[] fieldArray = fields = clazz.getFields();
        int n3 = fields.length;
        n = 0;
        while (n < n3) {
            Field field = fieldArray[n];
            if (!map.containsKey(field.getName())) {
                PropertyDescImpl pd = new PropertyDescImpl(this, field.getName(), field.getType(), field, null, null);
                list.add(pd);
                this.propertyMap.put(pd.getPropertyName(), pd);
            }
            ++n;
        }
        this.propertyArray = list.toArray(new PropertyDesc[list.size()]);
    }

    @Override
    public Class<?> getType() {
        return this.clazz;
    }

    @Override
    public PropertyDesc getPropertyDesc(String name) {
        return this.propertyMap.get(name);
    }

    @Override
    public int getPropertyDescSize() {
        return this.propertyArray.length;
    }

    @Override
    public PropertyDesc getPropertyDesc(int i) {
        return this.propertyArray[i];
    }

    protected static String getProperyName(String methodName) {
        if (methodName.startsWith("get") || methodName.startsWith("set")) {
            methodName = methodName.substring(3);
        }
        if (methodName.startsWith("is")) {
            methodName = methodName.substring(2);
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < methodName.length()) {
            char c = methodName.charAt(i);
            if (i == 0) {
                sb.append(String.valueOf(c).toLowerCase());
            } else {
                sb.append(c);
            }
            ++i;
        }
        return sb.toString();
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> type) {
        return this.clazz.getAnnotation(type);
    }

    private static class PropertyInfo {
        public String name;
        public Class<?> type;
        public Method getterMethod;
        public Method setterMethod;

        private PropertyInfo() {
        }
    }
}

