/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.amateras.mirage.filter;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import jp.sf.amateras.mirage.session.Session;
import jp.sf.amateras.mirage.session.SessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenSessionInViewFilter
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(OpenSessionInViewFilter.class);

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        Session session = SessionFactory.getSession();
        try {
            session.begin();
        }
        catch (Exception ex) {
            logger.error("Failed to begin Session.", (Throwable)ex);
            throw new RuntimeException(ex);
        }
        try {
            try {
                chain.doFilter(request, response);
                try {
                    session.commit();
                }
                catch (Exception ex) {
                    logger.error("Failed to commit Session.", (Throwable)ex);
                    throw new RuntimeException(ex);
                }
            }
            catch (Exception ex) {
                try {
                    session.rollback();
                }
                catch (Exception e) {
                    logger.error("Failed to rollback Session.", (Throwable)e);
                    throw new RuntimeException(e);
                }
                try {
                    session.release();
                }
                catch (Exception ex2) {
                    logger.error("Failed to release Session.", (Throwable)ex2);
                    throw new RuntimeException(ex2);
                }
            }
        }
        finally {
            try {
                session.release();
            }
            catch (Exception ex) {
                logger.error("Failed to release Session.", (Throwable)ex);
                throw new RuntimeException(ex);
            }
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }
}

