package tk.eclipse.plugin.htmleditor;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.dialogs.PropertyPage;

import tk.eclipse.plugin.jseditor.editors.additional.AdditionalJavaScriptCompleterManager;
import tk.eclipse.plugin.jseditor.launch.JavaScriptLibraryTable;

/**
 * The property page for the JavaScript editor.
 * 
 * @author Naoki Takezoe
 */
public class JavaScriptPropertyPage extends PropertyPage {
	
	private HTMLProjectParams params;
	private TabFolder tabFolder;
	private JavaScriptLibraryTable tableViewer;
	private Table additionalCompleters;
	
	public JavaScriptPropertyPage(){
		super();
		setDescription(HTMLPlugin.getResourceString("JavaScriptPropertyPage.Description"));
	}
	
	protected Control createContents(Composite parent) {
		tabFolder = new TabFolder(parent, SWT.NULL);
		tableViewer = new JavaScriptLibraryTable(tabFolder);
		
		TabItem tab1 = new TabItem(tabFolder, SWT.NULL);
		tab1.setText("Libraries"); // TODO i18n
		tab1.setControl(tableViewer.getControl());
		
		TabItem tab2 = new TabItem(tabFolder, SWT.NULL);
		tab2.setText("Code Completion"); // TODO i18n
		
		additionalCompleters = new Table(tabFolder, SWT.CHECK|SWT.BORDER);
		additionalCompleters.setLayoutData(new GridData(GridData.FILL_BOTH));
		String[] names = AdditionalJavaScriptCompleterManager.getAdditionalJavaScriptCompleterNames();
		for(int i=0;i<names.length;i++){
			new TableItem(additionalCompleters, SWT.NULL).setText(names[i]);
		}
		tab2.setControl(additionalCompleters);
		
		try {
			params = new HTMLProjectParams(getProject());
		} catch (Exception ex) {
			HTMLPlugin.logException(ex);
		}
		fillControls();
		
		return tabFolder;
	}
	
	private void fillControls(){
		List<Object> tableModel = tableViewer.getModel();
		tableModel.clear();
		String[] javaScripts = params.getJavaScripts();
		IWorkspaceRoot wsroot = ResourcesPlugin.getWorkspace().getRoot();
		
		for(int i=0;i<javaScripts.length;i++){
			if(javaScripts[i].startsWith(JavaScriptLibraryTable.PREFIX)){
				IResource resource = wsroot.findMember(javaScripts[i].substring(JavaScriptLibraryTable.PREFIX.length()));
				if(resource!=null && resource instanceof IFile && resource.exists()){
					tableModel.add((IFile)resource);
				}
			} else {
				tableModel.add(new File(javaScripts[i]));
			}
		}
		tableViewer.refresh();
		
		String[] javaScriptCompleters = params.getJavaScriptCompleters();
		for(int i=0;i<javaScriptCompleters.length;i++){
			TableItem[] items = additionalCompleters.getItems();
			for(int j=0;j<items.length;j++){
				if(items[j].getText().equals(javaScriptCompleters[i])){
					items[j].setChecked(true);
				}
			}
		}
	}
	
	protected void performDefaults() {
		params = new HTMLProjectParams();
		fillControls();
	}
	
	public boolean performOk() {
		// save configuration
		try {
			params = new HTMLProjectParams(getProject());
			List<Object> tableModel = tableViewer.getModel();
	
			String[] javaScripts = new String[tableModel.size()];
			for(int i=0;i<tableModel.size();i++){
				Object obj = tableModel.get(i);
				if(obj instanceof File){
					javaScripts[i] = ((File)obj).getAbsolutePath();
				} else if(obj instanceof IFile){
					javaScripts[i] = JavaScriptLibraryTable.PREFIX + ((IFile)obj).getFullPath().toString();
				}
			}
			params.setJavaScripts(javaScripts);
			
			TableItem[] items = additionalCompleters.getItems();
			List<String> javaScriptCompleters = new ArrayList<String>();
			for(int i=0;i<items.length;i++){
				if(items[i].getChecked()){
					javaScriptCompleters.add(items[i].getText());
				}
			}
			params.setJavaScriptCompleters(javaScriptCompleters.toArray(
					new String[javaScriptCompleters.size()]));
			
			params.save(getProject());
			
		} catch (Exception ex) {
			HTMLPlugin.logException(ex);
			return false;
		}
		return true;
	}
	
	private IProject getProject(){
		IAdaptable adaptable = getElement();
		return (IProject) adaptable.getAdapter(IProject.class);
	}
}
