package tk.eclipse.plugin.jseditor.editors;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultIndentLineAutoEditStrategy;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;

import tk.eclipse.plugin.htmleditor.HTMLPlugin;
import tk.eclipse.plugin.htmleditor.HTMLUtil;
import tk.eclipse.plugin.jseditor.editors.model.JavaScriptCallable;
import tk.eclipse.plugin.jseditor.editors.model.JavaScriptContext;
import tk.eclipse.plugin.jseditor.editors.model.JavaScriptModel;

/**
 * Provides auto inserting for JavaScript.
 *
 * @author Naoki Takezoe
 * @since 2.0.3
 */
public class JavaScriptAutoEditStrategy extends DefaultIndentLineAutoEditStrategy {

	protected boolean enable;

	public JavaScriptAutoEditStrategy(){
		IPreferenceStore store = HTMLPlugin.getDefault().getPreferenceStore();
		this.enable = store.getBoolean(HTMLPlugin.PREF_AUTO_EDIT);
	}

	/**
	 * @since 2.0.5
	 */
	public void setEnabled(boolean enable){
		this.enable = enable;
	}

	public void customizeDocumentCommand(IDocument document, DocumentCommand command) {
		if(enable){
			String text = command.text;
			String prev = "";
			String next = "";
			int offset = command.offset;
			if(offset > 0){
				try {
					prev = document.get(offset - 1, 1);
				} catch(BadLocationException ex){
					;
				}
			}
			if(offset < document.getLength() - 1){
				try {
					next = document.get(offset + 1, 1);
					if(next.equals("\n") || next.equals("\n") || next.equals(" ") || next.equals("\t")){
						next = "";
					}
				} catch(BadLocationException ex){
					;
				}
			}

			// {}
			if(text.equals("{") && next.equals("")){
				append(command, "}", 1);
				return;
			}
//			if(text.equals("}") && prev.equals("{")){
//				command.text = "";
//				command.caretOffset = offset + 1;
//				return;
//			}
			// []
			if(text.equals("[") && next.equals("")){
				append(command, "]", 1);
				return;
			}
//			if(text.equals("]") && prev.equals("[")){
//				command.text = "";
//				command.caretOffset = offset + 1;
//				return;
//			}
			// ()
			if(text.equals("(") && next.equals("")){
				append(command, ")", 1);
				return;
			}
//			if(text.equals(")") && prev.equals("(")){
//				command.text = "";
//				command.caretOffset = offset + 1;
//				return;
//			}
			//""
			if(text.equals("\"")){
				if(prev.equals("\"")){
					command.text = "";
					command.caretOffset = offset + 1;
					return;
				} else if(!prev.equals("\\")){
					append(command, "\"", 1);
					return;
				}
			}
			//''
			if(text.equals("'")){
				if(prev.equals("'")){
					command.text = "";
					command.caretOffset = offset + 1;
					return;
				} else if(!prev.equals("\\")){
					append(command, "'", 1);
					return;
				}
			}
			// JSDoc
			if(text.equals("\r\n") || text.equals("\n") || text.equals("\r")){
				try {
					String currLine = getLineText(document, command.offset);
					String nextLine = getLineText(document, command.offset + text.length());

					String trim = currLine.trim();

					if((trim.endsWith("/*") || trim.endsWith("/**")) && prev.equals("*")){
						String indent = getIndent(currLine);
						StringBuilder jsdoc = new StringBuilder();

						if(nextLine.indexOf("*") == -1){
							jsdoc.append(indent).append(" * ").append(text);
							if(nextLine.length() > 0 && trim.endsWith("/**")){
								String source = document.get();
								source = source.substring(0, command.offset - 3) + "   " + source.subSequence(command.offset, source.length());

								int currentLine = document.getLineOfOffset(command.offset);
								int nextLineEndOffset = document.getLineOffset(currentLine + 1) + document.getLineLength(currentLine + 1);

								JavaScriptModel model = new JavaScriptModel(HTMLUtil.getActiveFile(), source);
								JavaScriptContext context = model.getContextFromOffset(nextLineEndOffset);

								if(context instanceof JavaScriptCallable){
									JavaScriptCallable func = (JavaScriptCallable) context;
									String arguments = func.getArguments();
									if(arguments.length() > 0){
										String[] args = arguments.split(",");
										for(String arg: args){
											jsdoc.append(indent).append(" * @param {} ").append(arg.trim()).append(text);
										}
									}
									jsdoc.append(indent).append(" * @return ").append(text);
									jsdoc.append(indent).append(" * @type ").append(text);
								}
							}
							jsdoc.append(indent).append(" */");

							append(command, jsdoc.toString(), indent.length() + 5);

						} else {
							append(command, indent + " * ", indent.length() + 5);
						}
					}
					if(trim.startsWith("*")){
						String indent = getIndent(currLine);
						append(command, indent + "* ", indent.length() + 3);
					}
				} catch(BadLocationException ex){
				}
			}
		}
		super.customizeDocumentCommand(document, command);
	}

	private static String getLineText(IDocument document, int offset) {
		try {
			int line = document.getLineOfOffset(offset);
			IRegion reg = document.getLineInformation(line);
			return document.get(reg.getOffset(), reg.getLength());
		} catch(BadLocationException ex){
			return "";
		}
	}


	private static String getIndent(String line) throws BadLocationException {
		StringBuilder sb = new StringBuilder();
		for(int i=0;i<line.length();i++){
			char c = line.charAt(i);
			if(c==' ' || c=='\t'){
				sb.append(c);
			} else {
				break;
			}
		}
		return sb.toString();
	}

	private void append(DocumentCommand command, String append, int position){
		command.text = command.text + append;
		command.doit = false;
		command.shiftsCaret = false;
		command.caretOffset = command.offset + position;
	}


}
