package tk.eclipse.plugin.jseditor.editors;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import tk.eclipse.plugin.htmleditor.HTMLUtil;
import tk.eclipse.plugin.jseditor.editors.JsDocParser.JsDoc;

/**
 * Provides utility methods about JavaScript.
 *
 * @author Naoki Takezoe
 */
public class JavaScriptUtil {

	public static JsDoc extractJsDoc(String source, int position){
		// extract JsDoc
		String comment = source.substring(0, position).trim();
		JsDoc jsDoc = null;
		if(comment.endsWith("*/")){
			int index = comment.lastIndexOf("/**");
			if(index >= 0){
				comment = comment.substring(index);
				jsDoc = JsDocParser.parse(comment);
			}
		}
		return jsDoc;
	}

	public static String removeComments(String source){
		source = HTMLUtil.cssComment2space(source);

		int index = 0;
		int last  = 0;

		StringBuffer sb = new StringBuffer();
		while((index = source.indexOf("//",last))!=-1){
			int end1 = source.indexOf("\n",index);
			int end2 = source.indexOf("\r",index);
			if(end1 > end2){
				end1 = end2;
			}
			if(end1 != -1){
				sb.append(source.substring(last,index));
				int length = end1 - index + 2;
				for(int i=0;i<length;i++){
					sb.append(" ");
				}
			} else {
				break;
			}
			last = end1 + 1;
		}
		if(last != source.length()-1){
			sb.append(source.substring(last));
		}
		return sb.toString();

	}

	public static boolean isWhitespace(char c){
		if(c==' ' || c=='\t' || c=='\r' || c=='\n'){
			return true;
		} else {
			return false;
		}
	}

	private static final Pattern ANON_FUNCTION_PATTERN = Pattern.compile(
			"function[\\s\r\n]*?\\((.*?)\\)[\\s\r\n]*?\\{", Pattern.DOTALL);

	public static String extractAnonFuncArguments(String source){
		Matcher matcher = ANON_FUNCTION_PATTERN.matcher(source);
		if(matcher.find() && matcher.start() == 0){
			String args = matcher.group(1).replaceAll("[\\s\r\n]*,[\\s\r\n]*",", ").trim();
			return args;
		}
		return null;
	}

}
