package tk.eclipse.plugin.jseditor.editors;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JsDocParser {

	private static final Pattern PATTERN_PARAM = Pattern.compile("@param\\s+(.*)");
	private static final Pattern PATTERN_RETURN = Pattern.compile("@return\\s+(.*)");
	private static final Pattern PATTERN_TYPE = Pattern.compile("@type\\s+(.*)");

	public static JsDoc parse(String comment){
		JsDoc jsDoc = new JsDoc();

		comment = comment.replaceAll("\r\n", "\n");
		comment = comment.replaceAll("\r", "\n");

		comment = comment.replaceFirst("^/\\*\\*\\s*", "");
		comment = comment.replaceFirst("\\s*\\*/$", "");

		StringBuilder sb = new StringBuilder();
		String[] lines = comment.split("\n");
		for(String line: lines){
			line = line.replaceFirst("^\\s*\\*\\s*", "");
			sb.append(line).append("\n");

			{
				Matcher matcher = PATTERN_PARAM.matcher(line);
				if(matcher.matches()){
					JsDocParam param = new JsDocParam();
					String[] dim = matcher.group(1).trim().split("\\s");
					StringBuilder desc = new StringBuilder();
					for(int i = 0; i < dim.length; i++){
						if(param.type == null && dim[i].startsWith("{") && dim[i].endsWith("}")){
							param.type = dim[i].substring(1, dim[i].length() - 1);
						} else if(param.name == null){
							param.name = dim[i];
						} else {
							desc.append(dim[i]).append(" ");
						}
					}
					param.desciption = desc.toString();
					jsDoc.params.add(param);
				}
			}
			{
				Matcher matcher = PATTERN_RETURN.matcher(line);
				if(matcher.matches()){
					jsDoc.returnDescription = matcher.group(1).trim();
				}
			}
			{
				Matcher matcher = PATTERN_TYPE.matcher(line);
				if(matcher.matches()){
					jsDoc.returnType = matcher.group(1).trim();
				}
			}
		}

		jsDoc.text = sb.toString();

		return jsDoc;
	}

	public static class JsDoc {
		public String text;
		public List<JsDocParam> params = new ArrayList<JsDocParam>();
		public String returnDescription;
		public String returnType;
	}

	public static class JsDocParam {
		public String name;
		public String type;
		public String desciption;
	}

}