package tk.eclipse.plugin.jseditor.editors.additional;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import tk.eclipse.plugin.htmleditor.IOUtil;
import tk.eclipse.plugin.jseditor.editors.JavaScriptAssistProcessor;
import tk.eclipse.plugin.jseditor.editors.JavaScriptAssistProcessor.AssistInfo;

/**
 * <code>IAdditionalJavaScriptCompleter</code> implementation for Adobe AIR.
 *
 * @author Naoki Takezoe
 */
public class AIRCompleter implements IAdditionalJavaScriptCompleter {

	private List<AssistInfo> air = new ArrayList<AssistInfo>();

	public AIRCompleter(){
		InputStream in = AIRCompleter.class.getResourceAsStream("AIRAliases.js");
		try {
			BufferedReader reader = new BufferedReader(new InputStreamReader(in));
			String line = null;
			Pattern pattern = Pattern.compile("air\\.([A-Za-z0-9]+)");
			while((line = reader.readLine()) != null){
				Matcher matcher = pattern.matcher(line);
				if(matcher.find()){
					String name = matcher.group(1);
					char c = name.charAt(0);
					if(c >= 'a' && c <= 'z'){
						air.add(new AssistInfo(JavaScriptAssistProcessor.FUNCTION, name + "()", name + "()"));
					} else {
						air.add(new AssistInfo(JavaScriptAssistProcessor.OBJECT, name, name));
					}
				}
			}
		} catch(IOException ex){

		} finally {
			IOUtil.closeQuietly(in);
		}
	}

	private static AssistInfo createAssistInfo(int type, String displayString, String replaceString){
		return new AssistInfo(type, displayString + " - AIR", replaceString);
	}

	private static AssistInfo[] GLOBAL_MEMBERS = new AssistInfo[]{
		createAssistInfo(JavaScriptAssistProcessor.OBJECT, "air", "air"),
	};

	private static Map<String, AssistInfo[]> INSTANCE_MEMBERS = null;

	public Map<String, AssistInfo[]> getInstanceMembers() {
		if(INSTANCE_MEMBERS == null){
			INSTANCE_MEMBERS = new HashMap<String, AssistInfo[]>();

			INSTANCE_MEMBERS.put("air", air.toArray(new AssistInfo[air.size()]));

			INSTANCE_MEMBERS.put("Clipboard", new AssistInfo[]{
					createAssistInfo(JavaScriptAssistProcessor.VARIABLE, "generalClipboard", "generalClipboard"),
			});

			INSTANCE_MEMBERS.put("File", new AssistInfo[]{
					createAssistInfo(JavaScriptAssistProcessor.VARIABLE, "applicationResourceDirectory", "applicationResourceDirectory"),
					createAssistInfo(JavaScriptAssistProcessor.VARIABLE, "applicationStorageDirectory", "applicationStorageDirectory"),
					createAssistInfo(JavaScriptAssistProcessor.VARIABLE, "desktopDirectory", "desktopDirectory"),
					createAssistInfo(JavaScriptAssistProcessor.VARIABLE, "documentsDirectory", "documentsDirectory"),
					createAssistInfo(JavaScriptAssistProcessor.VARIABLE, "userDirectory", "userDirectory"),
			});

			INSTANCE_MEMBERS.put("FileMode", new AssistInfo[]{
					createAssistInfo(JavaScriptAssistProcessor.VARIABLE, "READ", "READ"),
					createAssistInfo(JavaScriptAssistProcessor.VARIABLE, "WRITE", "WRITE"),
					createAssistInfo(JavaScriptAssistProcessor.VARIABLE, "APPEND", "APPEND"),
					createAssistInfo(JavaScriptAssistProcessor.VARIABLE, "UPDATE", "UPDATE"),
			});
		}

		return INSTANCE_MEMBERS;
	}

	public AssistInfo[] getGlobalAssistInformations() {
		return GLOBAL_MEMBERS;
	}

	public boolean isLibraryScriptFile(String fileName) {
		return fileName.equals("AIRAliases.js");
	}

	public String resolveType(String source) {
		// TODO not implemented yet
		return null;
	}

	public Map<String, AssistInfo[]> getStaticMembers() {
		return Collections.emptyMap();
	}

}
