package tk.eclipse.plugin.jseditor.editors.additional;

import java.util.Map;

import tk.eclipse.plugin.jseditor.editors.JavaScriptAssistProcessor.AssistInfo;

/**
 * Provides additional JavaScript completion proposals.
 *
 * @author Naoki Takezoe
 */
public interface IAdditionalJavaScriptCompleter {

	/**
	 * Returns global completion proposals such as global functions
	 * and variables and classes.
	 *
	 * @return completion proposals
	 */
	public AssistInfo[] getGlobalAssistInformations();

	/**
	 * Returns instance members.
	 *
	 * @return <ul>
	 *   <li>key: object name</li>
	 *   <li>value: array of {@link AssistInfo}</li>
	 * </ul>
	 */
	public Map<String, AssistInfo[]> getInstanceMembers();

	/**
	 * Returns static members.
	 *
	 * @return <ul>
	 *   <li>key: object name</li>
	 *   <li>value: array of {@link AssistInfo}</li>
	 * </ul>
	 */
	public Map<String, AssistInfo[]> getStaticMembers();

	public String resolveType(String source);

	/**
	 * Returns <code>true</code> if the given file name is supported
	 * by this completer.
	 *
	 * @param fileName the file name
	 * @return Returns <code>true</code> if the given file name is
	 *   supported by this completer.
	 */
	public boolean isLibraryScriptFile(String fileName);

}
