package tk.eclipse.plugin.jseditor.editors.additional;

import java.util.HashMap;
import java.util.Map;

import tk.eclipse.plugin.jseditor.editors.JavaScriptAssistProcessor;
import tk.eclipse.plugin.jseditor.editors.JavaScriptAssistProcessor.AssistInfo;

/**
 * <code>IAdditionalJavaScriptCompleter</code> implementation for <strong>jQuery</strong>.
 *
 * @author Naoki Takezoe
 */
public class JQueryCompleter implements IAdditionalJavaScriptCompleter {

	private static AssistInfo createAssistInfo(int type, String displayString, String replaceString){
		return new AssistInfo(type, displayString + " - jQuery", replaceString);
	}

	private static AssistInfo createAssistInfo(int type, String displayString, String replaceString, String returnType){
		return new AssistInfo(type, displayString + " - jQuery", replaceString, returnType);
	}

	private static AssistInfo[] GLOBAL_MEMBERS = new AssistInfo[]{
		createAssistInfo(JavaScriptAssistProcessor.OBJECT, "jQuery", "jQuery"),
		createAssistInfo(JavaScriptAssistProcessor.OBJECT, "$", "$$"),
		createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "$(element)", "$$(${element})"),
	};

	private static Map<String, AssistInfo[]> INSTANCE_MEMBERS;
	private static Map<String, AssistInfo[]> STATIC_MEMBERS;

	public Map<String, AssistInfo[]> getInstanceMembers() {
		if(INSTANCE_MEMBERS == null){
			INSTANCE_MEMBERS = new HashMap<String, AssistInfo[]>();

			INSTANCE_MEMBERS.put("jQuery", new AssistInfo[]{
					// Manipulation
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "addClass(className)", "addClass(${className})", "jQuery"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "after(content)", "after(${content})", "jQuery"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "append(content)", "append(${content})", "jQuery"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "appendTo(target)", "appendTo(${target})", "jQuery"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "attr(attributeName[, value])", "attr(${attributeName}, ${value})", "jQuery"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "before(content)", "before(${content})", "jQuery"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "clone([withDataAndEvents])", "clone(${withDataAndEvents})", "jQuery"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "css(propertyName[, value])", "css(${propertyName}, ${value})", "jQuery"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "detach([selector])", "detach(${selector})", "jQuery"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "empty()", "empty()", "jQuery"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "hasClass(className)", "hasClass(${className})", "jQuery"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "height([value])", "height(${value})", "jQuery"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "html([htmlString])", "html(${htmlString})", "jQuery"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "innerHeight()", "innerHeight()", "jQuery"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "innerWidth()", "innerWidth()", "jQuery"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "insertAfter(target)", "insertAfter(${target})", "jQuery"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "insertBefore(target)", "insertBefore(${target})", "jQuery"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "offset([coordinates])", "offset(${coordinates})", "jQuery"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "outerHeight([includeMargin])", "outerHeight(${includeMargin})", "jQuery"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "outerWidth([includeMargin])", "outerWidth(${includeMargin})", "jQuery"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "position()", "position()", "jQuery"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "prepend(content)", "prepend(${content})", "jQuery"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "prependTo(target)", "prependTo(${target})", "jQuery"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "remove(selector)", "remove(${selector})", "jQuery"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "removeAttr(attributeName)", "removeAttr(${attributeName})", "jQuery"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "removeClass(className)", "removeClass(${className})", "jQuery"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "replaceAll()", "replaceAll()", "jQuery"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "replaceWith([newContent])", "replaceWith(${newContent})", "jQuery"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "scrollLeft([value])", "scrollLeft(${value})", "jQuery"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "scrollTop([value])", "scrollTop(${value})", "jQuery"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "text([textString])", "text(${textString})", "jQuery"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "toggleClass(className)", "toggleClass(${className})", "jQuery"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "unwrap()", "unwrap()", "jQuery"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "val([value])", "val(${value})", "jQuery"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "width([value])", "width(${value})", "jQuery"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "wrap(wrappingElement)", "wrap(${wrappingElement})", "jQuery"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "wrapAll(wrappingElement)", "wrapAll(${wrappingElement})", "jQuery"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "wrapInner(wrappingElement)", "wrapInner(${wrappingElement})", "jQuery"),
					// Event
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "bind(eventType[, eventData], handler(eventObject))", "bind()", "jQuery"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "blur(handler(eventObject))", "blur()", "jQuery"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "change(handler(eventObject))", "change()", "jQuery"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "click(handler(eventObject))", "click()", "jQuery"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "dblckick(handler(eventObject))", "dblclick()", "jQuery"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "delegate(selector, eventType[, eventData], handler)", "delegate()", "jQuery"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "die([eventType[, handler]])", "die()", "jQuery"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "error(andler(eventObject))", "error()", "jQuery"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "focus(handler(eventObject))", "focus()", "jQuery"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "focusin(handler(eventObject))", "focusin()", "jQuery"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "focusout(handler(eventObject))", "focusout()", "jQuery"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "hover(handlerIn(eventObject), handlerOut(eventObject))", "hover()", "jQuery"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "keydown(handler(eventObject))", "keydown()", "jQuery"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "keypress(handler(eventObject))", "keypress()", "jQuery"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "keyup(handler(eventObject))", "keyup()", "jQuery"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "live(eventType, handler)", "live()", "jQuery"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "load(handler(eventObject))", "load()", "jQuery"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "mousedown(handler(eventObject))", "mousedown()", "jQuery"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "mouseenter(handler(eventObject))", "mouseenter()", "jQuery"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "mouseleave(handler(eventObject))", "mouseleave()", "jQuery"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "mousemove(handler(eventObject))", "mousemove()", "jQuery"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "mouseout(handler(eventObject))", "mouseout()", "jQuery"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "mouseover(handler(eventObject))", "mouseover()", "jQuery"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "mouseup(handler(eventObject))", "mouseup()", "jQuery"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "one(eventType[, eventData], handler(eventObject))", "one()", "jQuery"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "ready(handler(eventObject))", "ready()", "jQuery"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "resize(handler(eventObject))", "resize()", "jQuery"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "scroll(handler(eventObject))", "scroll()", "jQuery"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "select(handler(eventObject))", "select()", "jQuery"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "submit(handler(eventObject))", "submit()", "jQuery"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "toggle(handler(eventObject), handler(eventObject)[, handler(eventObject)])", "toggle()", "jQuery"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "trigger(eventType, extraParameters)", "trigger()", "jQuery"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "triggerHandler(eventType, extraParameters)", "triggerHandler()", "jQuery"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "unbind(eventType, handler(eventObject))", "unbind()", "jQuery"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "undelegate([selector[, eventType[, handler]]])", "undelegate()", "jQuery"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "unload(handler(eventObject))", "unload()", "jQuery"),
					// Ajax
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "ajaxComplete(handler(event, XMLHttpRequest, ajaxOptions))", "ajaxComplete()", "jQuery"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "ajaxError(handler(event, XMLHttpRequest, ajaxOptions, thrownError))", "ajaxError()", "jQuery"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "ajaxSend(handler(event, XMLHttpRequest, ajaxOptions))", "ajaxSend()", "jQuery"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "ajaxStart(handler())", "ajaxStart()", "jQuery"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "ajaxStop(handler())", "ajaxStop()", "jQuery"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "ajaxSuccess(handler(event, XMLHttpRequest, ajaxOptions))", "ajaxSuccess()", "jQuery"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "load( url[, data ][, complete(responseText, textStatus, XMLHttpRequest)])", "load(${url})", "jQuery"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "serialize()", "serialize()", "jQuery"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "serializeArray()", "serializeArray()", "jQuery"),
					// Traversing
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "add(html)", "add(${html})", "jQuery"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "andSelf()", "andSelf()", "jQuery"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "children([selector])", "selector(${selector})", "jQuery"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "closest(selector[, context])", "closest(${selector}, ${context})", "jQuery"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "contents()", "contents()", "jQuery"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "each(function(index, Element))", "each(${function})", "jQuery"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "end()", "end()", "jQuery"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "eq(index)", "eq(${index})", "jQuery"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "filter(selector)", "filter(${selector})", "jQuery"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "find(selector)", "find(${selector})", "jQuery"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "first()", "first()", "jQuery"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "has(selector)", "has(${selector})", "jQuery"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "is(selector)", "is(${selector})", "jQuery"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "last()", "last()", "jQuery"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "map(callback(index, domElement))", "map(${callback})", "jQuery"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "next([selector])", "next(${selector})", "jQuery"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "nextAll([selector])", "nextAll(${selector})", "jQuery"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "nextUntil([selector])", "nextUntil(${selector})", "jQuery"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "not(selector)", "not(${selector})", "jQuery"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "offsetParent()", "offsetParent()", "jQuery"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "parent([selector])", "parent(${selector})", "jQuery"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "parents([selector])", "parents(${selector})", "jQuery"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "parentsUntil([selector])", "parentsUntil(${selector})", "jQuery"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "prev([selector])", "prev(${selector})", "jQuery"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "prevAll([selector])", "prevAll(${selector})", "jQuery"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "prevUntil([selector])", "prevUntil(${selector})", "jQuery"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "siblings([selector])", "siblings(${selector})", "jQuery"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "slice(start[, end])", "slice(${start}, ${end})", "jQuery"),
					//Sliding
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "slideDown([duration], [callback])", "slideDown(${duration}, ${callback})", "jQuery"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "slideToggle([duration], [callback])", "slideToggle(${duration}, ${callback})", "jQuery"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "slideUp([duration], [callback])", "slideUp(${duration}, ${callback})", "jQuery"),
			});

			INSTANCE_MEMBERS.put("event", new AssistInfo[]{
					createAssistInfo(JavaScriptAssistProcessor.VARIABLE, "currentTarget", "currentTarget"),
					createAssistInfo(JavaScriptAssistProcessor.VARIABLE, "data", "data"),
					createAssistInfo(JavaScriptAssistProcessor.VARIABLE, "pageX", "pageX"),
					createAssistInfo(JavaScriptAssistProcessor.VARIABLE, "pageY", "pageY"),
					createAssistInfo(JavaScriptAssistProcessor.VARIABLE, "relatedTarget", "relatedTarget"),
					createAssistInfo(JavaScriptAssistProcessor.VARIABLE, "result", "result"),
					createAssistInfo(JavaScriptAssistProcessor.VARIABLE, "target", "target"),
					createAssistInfo(JavaScriptAssistProcessor.VARIABLE, "timeStamp", "timeStamp"),
					createAssistInfo(JavaScriptAssistProcessor.VARIABLE, "type", "type"),
					createAssistInfo(JavaScriptAssistProcessor.VARIABLE, "which", "which"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "isDefaultPrevented()", "isDefaultPrevented()"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "isImmediatePropagationStopped()", "isImmediatePropagationStopped()"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "isPropagationStopped()", "isPropagationStopped()"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "preventDefault()", "preventDefault()"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "stopImmediatePropagation()", "stopImmediatePropagation()"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "stopPropagation()", "stopPropagation()"),
			});

			INSTANCE_MEMBERS.put("$", new AssistInfo[]{
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "proxy(function, context)", "proxy(${function}, ${context})"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "ajax(settings)", "ajax(${settings})"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "ajaxSetup(options)", "ajaxSetup(${options})"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "get(url[, data][, callback(data, textStatus, XMLHttpRequest)][, dataType])", "get(${url})"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "getJSON( url[, data][, callback(data, textStatus)])", "getJSON(${url})"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "getScript(url[, success(data, textStatus)])", "getScript(${url})"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "param(obj)", "param(${obj})"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "post(url[, data][, success(data, textStatus, XMLHttpRequest)][, dataType])", "post(${url})"),
			});
		}

		return INSTANCE_MEMBERS;
	}

	public Map<String, AssistInfo[]> getStaticMembers() {
		if(STATIC_MEMBERS == null){
			STATIC_MEMBERS = new HashMap<String, AssistInfo[]>();

			STATIC_MEMBERS.put("jQuery", new AssistInfo[]{
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "proxy(function, context)", "proxy(${function}, ${context})"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "ajax(settings)", "ajax(${settings})"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "ajaxSetup(options)", "ajaxSetup(${options})"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "get(url[, data][, callback(data, textStatus, XMLHttpRequest)][, dataType])", "get(${url})"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "getJSON( url[, data][, callback(data, textStatus)])", "getJSON(${url})"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "getScript(url[, success(data, textStatus)])", "getScript(${url})"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "param(obj)", "param(${obj})"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "post(url[, data][, success(data, textStatus, XMLHttpRequest)][, dataType])", "post(${url})"),
			});

		}
		return STATIC_MEMBERS;
	}

	public AssistInfo[] getGlobalAssistInformations() {
		return GLOBAL_MEMBERS;
	}

	public boolean isLibraryScriptFile(String fileName) {
		return fileName.startsWith("jquery") && fileName.endsWith(".js");
	}

	public String resolveType(String source) {
		if("$".equals(source)){
			return "jQuery";
		}
		for(AssistInfo info: getInstanceMembers().get("jQuery")){
			if(info.getReplaceString().startsWith(source + "(")){
				return info.getReturnType();
			}
		}
		return null;
	}


}
