package tk.eclipse.plugin.jseditor.editors.additional;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

import tk.eclipse.plugin.jseditor.editors.JavaScriptAssistProcessor;
import tk.eclipse.plugin.jseditor.editors.JavaScriptAssistProcessor.AssistInfo;

/**
 * <code>IAdditionalJavaScriptCompleter</code> implementation for <strong>prototype.js</strong>.
 *
 * @author Naoki Takezoe
 */
public class PrototypeCompleter implements IAdditionalJavaScriptCompleter {

	private static AssistInfo createAssistInfo(int type, String displayString, String replaceString){
		return new AssistInfo(type, displayString + " - prototype.js", replaceString);
	}

	private static AssistInfo[] GLOBAL_MEMBERS = new AssistInfo[]{
		createAssistInfo(JavaScriptAssistProcessor.OBJECT, "Ajax", "Ajax"),
		createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "$(element)", "$$(${element})"),
		createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "$$(cssRule...)", "$$$$(${cssRule})"),
		createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "$F(element)", "$$F(${element})"),
		createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "$A(iterable)", "$$A(${iterable})"),
		createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "$H([obj])", "$$H(${obj})"),
		createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "$R(start, end[, exclusive = false])", "$$R(${start}, ${end}, ${exclusive})"),
		createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "$w(string)", "$$w(${string})"),
		createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "Try.these(Function...)", "Try.these(${function})")
	};


	private static Map<String, AssistInfo[]> INSTANCE_MEMBERS;

	public AssistInfo[] getGlobalAssistInformations() {
		return GLOBAL_MEMBERS;
	}

	public Map<String, AssistInfo[]> getInstanceMembers(){
		if(INSTANCE_MEMBERS == null){
			INSTANCE_MEMBERS = new HashMap<String, AssistInfo[]>();

			INSTANCE_MEMBERS.put("Object", new AssistInfo[]{
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "extend(dest, src)", "extend()"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "hide()", "hide()"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "scrollTo()", "scrollTo()"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "addClassName()", "addClassName()"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "bind()", "bind()"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "bindAsEventListener()", "bindAsEventListener()"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "toJSON()", "toJSON()"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "isArray(obj)", "isArray()"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "isHash(obj)", "isHash()"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "isElement(obj)", "isElement()"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "isFunction(obj)", "isFunction()"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "isNumber(obj)", "isNumber()"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "isString(obj)", "isString()"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "isUndefined(obj)", "isUndefined()")
			});
			INSTANCE_MEMBERS.put("Class", new AssistInfo[]{
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "create([superclass][, methods...])", "create()")
			});
			INSTANCE_MEMBERS.put("Event", new AssistInfo[]{
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "observe(element, eventName, handler[, useCapture = false])", "observe()"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "stopObserving(element, eventName, handler[, useCapture = false])", "stopObserving()")
			});
			INSTANCE_MEMBERS.put("Ajax", new AssistInfo[]{
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "Request(url[, options])", "Request()"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "Updater(container, url[, options])", "Updater()"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "PeriodicalUpdater(container, url[, options])", "PeriodicalUpdater()"),
					createAssistInfo(JavaScriptAssistProcessor.VARIABLE, "Responders", "Responders"),
			});
			INSTANCE_MEMBERS.put("Responders", new AssistInfo[]{
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "register(responder)", "register()"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "unregister(responder)", "unregister()")
			});
			INSTANCE_MEMBERS.put("document", new AssistInfo[]{
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "getElementsByClassName(className[, element])", "getElementsByClassName()")
			});
		}

		return INSTANCE_MEMBERS;
	}

	public Map<String, AssistInfo[]> getStaticMembers() {
		return Collections.emptyMap();
	}

	public boolean isLibraryScriptFile(String fileName) {
		return fileName.startsWith("prototype") && fileName.endsWith(".js");
	}

	public String resolveType(String source) {
		if("$".equals(source)){
			return "HTMLElement";
		}
		return null;
	}



}
