package tk.eclipse.plugin.jseditor.editors.additional;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

import tk.eclipse.plugin.jseditor.editors.JavaScriptAssistProcessor;
import tk.eclipse.plugin.jseditor.editors.JavaScriptAssistProcessor.AssistInfo;

public class ScriptaculousCompleter implements IAdditionalJavaScriptCompleter {

	private static AssistInfo createAssistInfo(int type, String displayString, String replaceString){
		return new AssistInfo(type, displayString + " - script.aculo.us", replaceString);
	}

	private static AssistInfo[] GLOBAL_MEMBERS = new AssistInfo[]{
		createAssistInfo(JavaScriptAssistProcessor.OBJECT, "Effect", "Effect"),
		createAssistInfo(JavaScriptAssistProcessor.OBJECT, "Ajax", "Ajax"),
		createAssistInfo(JavaScriptAssistProcessor.OBJECT, "Autocompleter", "Autocompleter"),
		createAssistInfo(JavaScriptAssistProcessor.OBJECT, "Control", "Control"),
		createAssistInfo(JavaScriptAssistProcessor.OBJECT, "Draggable", "Draggable"),
		createAssistInfo(JavaScriptAssistProcessor.OBJECT, "Droppables", "Droppables"),
		createAssistInfo(JavaScriptAssistProcessor.OBJECT, "Builder", "Builder"),
	};

	private static Map<String, AssistInfo[]> INSTANCE_MEMBERS;

	public Map<String, AssistInfo[]> getInstanceMembers() {
		if(INSTANCE_MEMBERS == null){
			INSTANCE_MEMBERS = new HashMap<String, AssistInfo[]>();

			INSTANCE_MEMBERS.put("Effect", new AssistInfo[]{
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "Highlight()", "Highlight()"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "Morph()", "Morph()"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "Move()", "Move()"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "Opacity()", "Opacity()"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "Scale()", "Scale()"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "Parallel()", "Parallel()"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "Appear()", "Appear()"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "BlindDown()", "BlindDown()"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "BlindUp()", "BlindUp()"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "DropOut()", "DropOut()"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "Fade()", "Fade()"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "Fold()", "Fold()"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "Grow()", "Grow()"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "Puff()", "Puff()"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "Pulsate()", "Pulsate()"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "Shake()", "Shake()"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "Shrink()", "Shrink()"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "SlideDown()", "SlideDown()"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "SlideUp()", "SlideUp()"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "Squish()", "Squish()"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "SwitchOff()", "SwitchOff()"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "Transitions()", "Transitions()"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "Methods()", "Methods()"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "tagifyText()", "tagifyText()"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "multiple()", "multiple()"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "toggle()", "toggle()"),
			});
			INSTANCE_MEMBERS.put("Ajax", new AssistInfo[]{
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "InPlaceEditor()", "InPlaceEditor()"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "InPlaceCollectionEditor()", "InPlaceCollectionEditor()"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "Autocompleter()", "Autocompleter()"),
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "Opacity()", "Opacity()"),
			});
			INSTANCE_MEMBERS.put("Autocompleter", new AssistInfo[]{
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "Local()", "Local()"),
			});
			INSTANCE_MEMBERS.put("Control", new AssistInfo[]{
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "Slider()", "Slider()"),
			});
			INSTANCE_MEMBERS.put("Builder", new AssistInfo[]{
					createAssistInfo(JavaScriptAssistProcessor.FUNCTION, "node()", "node()"),
			});
		}

		return INSTANCE_MEMBERS;
	}

	public AssistInfo[] getGlobalAssistInformations() {
		return GLOBAL_MEMBERS;
	}

	public Map<String, AssistInfo[]> getStaticMembers() {
		return Collections.emptyMap();
	}

	public boolean isLibraryScriptFile(String fileName) {
		return fileName.startsWith("scriptaculous") && fileName.endsWith(".js");
	}

	public String resolveType(String source) {
		// TODO not implemented yet
		return null;
	}


}
