package tk.eclipse.plugin.jseditor.editors.model;

import java.util.ArrayList;
import java.util.List;

import tk.eclipse.plugin.jseditor.editors.JsDocParser.JsDoc;

/**
 * The model for the JavaScript function.
 *
 * @author Naoki Takezoe
 */
public class JavaScriptFunction implements JavaScriptElement, JavaScriptCallable {

	private String name;
	private String arguments;
	private int offset;
	private int end;
	private List<JavaScriptElement> children = new ArrayList<JavaScriptElement>();
	private JavaScriptContext parent;
	private JsDoc jsDoc;
	private boolean isMethod;

	public JavaScriptFunction(String name, String arguments, int offset, boolean isMethod){
		this.name = name;
		this.arguments = arguments;
		this.offset = offset;
		this.isMethod = isMethod;
	}

	public boolean isMethod(){
		return isMethod;
	}

	public void setJsDoc(JsDoc jsDoc){
		this.jsDoc = jsDoc;
	}

	public JsDoc getJsDoc(){
		return this.jsDoc;
	}

	public String getDescription(){
		if(jsDoc != null){
			return jsDoc.text;
		}
		return null;
	}

	public String getReturnType(){
		if(jsDoc != null){
			return jsDoc.returnType;
		}
		return null;
	}

	public String getArguments() {
		return arguments;
	}

	public String getName() {
		return name;
	}

	public int getOffset(){
		return offset;
	}

	public int getStartOffset(){
		return getOffset();
	}

	public void setEndOffset(int end){
		this.end = end;
	}

	public int getEndOffset(){
		return end;
	}

	public void add(JavaScriptFunction func){
		this.children.add(func);
	}

	public void add(JavaScriptVariable var){
		this.children.add(var);
	}

	public void add(JavaScriptProperty props){
		this.children.add(props);
	}

	public JavaScriptElement[] getChildren(){
		return this.children.toArray(new JavaScriptElement[this.children.size()]);
	}

	public JavaScriptProperty[] getProperties(){
		List<JavaScriptProperty> list = new ArrayList<JavaScriptProperty>();
		for(JavaScriptElement element: getChildren()){
			if(element instanceof JavaScriptProperty){
				list.add(JavaScriptProperty.class.cast(element));
			}
		}
		return list.toArray(new JavaScriptProperty[list.size()]);
	}

	public JavaScriptElement[] getVisibleElements(){
		List<JavaScriptElement> list = new ArrayList<JavaScriptElement>();

		JavaScriptContext context = this;
		while(context != null && context instanceof JavaScriptCallable){
			JavaScriptCallable callable = (JavaScriptCallable) context;
			String arguments = callable.getArguments();
			if(arguments != null && arguments.length() != 0){
				String[] args = arguments.split(",");
				for(String arg: args){
					list.add(new JavaScriptVariable(callable.getReturnType(), arg.trim(), offset));
				}
			}
			context = context.getParent();
		}

		context = this;
		while(true){
			JavaScriptElement[] children = context.getChildren();
			for(int i=0;i<children.length;i++){
				list.add(children[i]);
			}
			if(context.getParent()==null){
				break;
			} else {
				context = context.getParent();
			}
		}
		return list.toArray(new JavaScriptElement[list.size()]);
	}

	public void setParent(JavaScriptContext context){
		this.parent = context;
	}

	public JavaScriptContext getParent(){
		return parent;
	}


	public String toString(){
		return name + "(" + arguments + ")";
	}

	public String getReplaceString(){
		String replace = getName() + "(";
		if(getArguments().length() != 0){
			String[] args = getArguments().split(",");
			for(int i=0; i < args.length; i++){
				if(i != 0){
					replace = replace + ", ";
				}
				args[i] = args[i].replaceAll("/\\*.+?\\*/", "");
				replace = replace + "${" + args[i] + "}";
			}
		}
		replace = replace + ")";

		return replace;
	}

}
