package tk.eclipse.plugin.jseditor.editors.model;

import java.util.ArrayList;
import java.util.List;

import tk.eclipse.plugin.htmleditor.StringUtils;
import tk.eclipse.plugin.jseditor.editors.JsDocParser.JsDoc;

public class JavaScriptProperty implements JavaScriptElement, JavaScriptCallable {

	private String type;
	private String name;
	private boolean isStatic;
	private String arguments;
	private List<JavaScriptElement> children = new ArrayList<JavaScriptElement>();
	private JavaScriptContext parent;
	private int offset;
	private int end;
	private JsDoc jsDoc;

	public JavaScriptProperty(String type, String name, int offset, boolean isStatic){
		this.type = type;
		this.name = name;
		this.offset = offset;
		this.isStatic = isStatic;
	}

	public JsDoc getJsDoc() {
		return jsDoc;
	}

	public void setJsDoc(JsDoc jsDoc) {
		this.jsDoc = jsDoc;
	}

	public void setArguments(String arguments){
		this.arguments = arguments;
	}

	public String getArguments(){
		return this.arguments;
	}

	public boolean isStatic(){
		return isStatic;
	}

	public String getName() {
		return name;
	}

	public int getOffset(){
		return offset;
	}

	public String getType(){
		if(type == null){
			return "Object";
		}
		return type;
	}

	@Override
	public String toString(){
		if(getType().equals("Function")){
			if(StringUtils.isEmpty(getArguments())){
				return getName() + "(): " + getType();
			} else {
				return getName() + "(" + getArguments() + "): " + getType();
			}
		}
		return getName() + ": " + getType();
	}

	public String getReplaceString(){
		String replace = getName() + "(";
		if(getArguments().length() != 0){
			String[] args = getArguments().split(",");
			for(int i=0; i < args.length; i++){
				if(i != 0){
					replace = replace + ", ";
				}
				args[i] = args[i].replaceAll("/\\*.+?\\*/", "");
				replace = replace + "${" + args[i] + "}";
			}
		}
		replace = replace + ")";

		return replace;
	}

	public void add(JavaScriptFunction func) {
		children.add(func);
	}

	public void add(JavaScriptVariable var) {
		children.add(var);
	}

	public void add(JavaScriptProperty prop) {
		children.add(prop);
	}

	public JavaScriptElement[] getChildren() {
		return this.children.toArray(new JavaScriptElement[this.children.size()]);
	}

	public void setEndOffset(int end){
		this.end = end;
	}

	public int getEndOffset() {
		return end;
	}

	public void setParent(JavaScriptContext context){
		this.parent = context;
	}

	public JavaScriptContext getParent() {
		return parent;
	}

	public JavaScriptProperty[] getProperties() {
		List<JavaScriptProperty> list = new ArrayList<JavaScriptProperty>();
		for(JavaScriptElement element: getChildren()){
			if(element instanceof JavaScriptProperty){
				list.add(JavaScriptProperty.class.cast(element));
			}
		}
		return list.toArray(new JavaScriptProperty[list.size()]);
	}

	public int getStartOffset() {
		return offset;
	}

	public JavaScriptElement[] getVisibleElements() {
		List<JavaScriptElement> list = new ArrayList<JavaScriptElement>();

		JavaScriptContext context = this;
		while(context != null && context instanceof JavaScriptCallable){
			JavaScriptCallable callable = (JavaScriptCallable) context;
			String arguments = callable.getArguments();
			if(arguments != null && arguments.length() != 0){
				String[] args = arguments.split(",");
				for(String arg: args){
					list.add(new JavaScriptVariable(callable.getReturnType(), arg.trim(), offset));
				}
			}
			context = context.getParent();
		}

		context = this;
		while(true){
			JavaScriptElement[] children = context.getChildren();
			for(int i=0;i<children.length;i++){
				list.add(children[i]);
			}
			if(context.getParent()==null){
				break;
			} else {
				context = context.getParent();
			}
		}
		return list.toArray(new JavaScriptElement[list.size()]);
	}

	// TODO not implemented yet.
	public String getReturnType() {
		return "Object";
	}

}
