package tk.eclipse.plugin.jseditor.editors.model;


/**
 * The model for the JavaScript variable.
 * 
 * @author Naoki Takezoe
 */
public class JavaScriptVariable implements JavaScriptElement {
	
	private String type;
	private String name;
	private int offset;
	
	public JavaScriptVariable(String type, String name, int offset){
		this.type = type;
		this.name = name;
		this.offset = offset;
	}
	
	public String getName() {
		return name;
	}
	
	public int getOffset(){
		return offset;
	}
	
	public String getType(){
		if(type == null){
			return "Object";
		}
		return type;
	}
	
	public String toString(){
		return getName() + ": " + getType();
	}
}
