package tk.eclipse.plugin.jseditor.editors.model;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;

import tk.eclipse.plugin.htmleditor.HTMLPlugin;
import tk.eclipse.plugin.htmleditor.HTMLProjectParams;
import tk.eclipse.plugin.htmleditor.IOUtil;
import tk.eclipse.plugin.jseditor.launch.JavaScriptLibraryTable;

public class ModelManager {

	private static ModelManager instance;
	private Map<Object, ModelInfo> models = new HashMap<Object, ModelInfo>();

	private ModelManager(){
	}

	public static ModelManager getInstance(){
		if(instance == null){
			instance = new ModelManager();
		}
		return instance;
	}

	public List<JavaScriptModel> getProjectLibModels(IProject project){
		List<JavaScriptModel> result = new ArrayList<JavaScriptModel>();

		try {
			HTMLProjectParams params = new HTMLProjectParams(project);
			String[] javaScripts = params.getJavaScripts();
			IWorkspaceRoot wsroot = ResourcesPlugin.getWorkspace().getRoot();

			for(int i = 0; i < javaScripts.length; i++){
				if(javaScripts[i].startsWith(JavaScriptLibraryTable.PREFIX)){
					IResource resource = wsroot.findMember(javaScripts[i].substring(JavaScriptLibraryTable.PREFIX.length()));
					if(resource!=null && resource instanceof IFile && resource.exists()){
						result.add(getModel((IFile) resource));
					}
				} else {
					File file = new File(javaScripts[i]);
					result.add(getModel(file));
				}
			}

		} catch(Exception ex){
			HTMLPlugin.logException(ex);
		}

		return result;
	}

	public JavaScriptModel getModel(IFile file){
		ModelInfo info = models.get(file);
		if(info == null || info.lastModified != file.getModificationStamp()){
			try {
				InputStream in = file.getContents();
				String source = new String(IOUtil.readStream(in), file.getCharset());
				JavaScriptModel model = new JavaScriptModel(file, source);

				info = new ModelInfo();
				info.model = model;
				info.lastModified = file.getModificationStamp();

				models.put(file, info);
			} catch(Exception ex){
				HTMLPlugin.logException(ex);
			}
		}
		return info.model;
	}

	public JavaScriptModel getModel(File file){
		ModelInfo info = models.get(file);
		if(info == null || info.lastModified != file.lastModified()){
			try {
				InputStream in = new FileInputStream(file);
				String source = new String(IOUtil.readStream(in));
				JavaScriptModel model = new JavaScriptModel(null, source);

				info = new ModelInfo();
				info.model = model;
				info.lastModified = file.lastModified();

				models.put(file, info);
			} catch(Exception ex){
				HTMLPlugin.logException(ex);
			}
		}
		return info.model;
	}

	public Object getResourceByModel(JavaScriptModel model){
		for(Map.Entry<Object, ModelInfo> entry: models.entrySet()){
			if(entry.getValue().model == model){
				return entry.getKey();
			}
		}
		return null;
	}

	public List<JavaScriptModel> getModels(){
		List<JavaScriptModel> result = new ArrayList<JavaScriptModel>();
		for(ModelInfo info: models.values()){
			result.add(info.model);
		}
		return result;
	}

	private static class ModelInfo {
		public JavaScriptModel model;
		public long lastModified;
	}

}
