package tk.eclipse.plugin.struts;

import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;

public class FormInfo {
	
	private String formName;
	private IType type;
	private String className;
	private PropertyInfo[] dynaProperties;
	
	/**
	 * Constructor.
	 *
	 * @param formName name of ActionForm
	 * @param type type of ActionForm
	 * @param dynaPropeties propeties of DynaActionForm
	 */
	public FormInfo(String formName,IType type,PropertyInfo[] dynaPropeties){
		this.formName = formName;
		this.type = type;
		this.className = type.getFullyQualifiedName();
		this.dynaProperties = dynaPropeties;
	}
	
	public FormInfo(String formName,String className,PropertyInfo[] dynaPropeties){
		this.formName = formName;
		this.className = className;
		this.dynaProperties = dynaPropeties;
	}
	
	/**
	 * Returns name of ActionForm.
	 * 
	 * @return name of ActionForm
	 */
	public String getFormName(){
		return this.formName;
	}
	
	/**
	 * Returns class name of ActionForm
	 * 
	 * @return class name of ActionForm
	 */
	public String getClassName(){
		return this.className;
	}
	
	/**
	 * Returns properties of ActionForm.
	 * 
	 * @return properties of ActionForm
	 */
	public PropertyInfo[] getProperties(){
		// DynaActionForm
		if(dynaProperties!=null && dynaProperties.length!=0){
			return dynaProperties;
		}
		
		if(type!=null){
			try {
				return Util.getProperties(type);
			} catch(JavaModelException ex){
				// ignore
			}
		}
		return new PropertyInfo[0];
	}
	
	public PropertyInfo getProperty(String propertyName){
		for(PropertyInfo propertyInfo: getProperties()){
			if(propertyInfo.getPropertyName().equals(propertyName)){
				return propertyInfo;
			}
		}
		return null;
	}

}
