package tk.eclipse.plugin.struts;

import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

import tk.eclipse.plugin.htmleditor.gefutils.SpinnerFieldEditor;

/**
 * 
 * @author Naoki Takezoe
 */
public class GraphicalEditorPreferencePage extends PreferencePage implements
		IWorkbenchPreferencePage {

	private BooleanFieldEditor showGrid;
	private SpinnerFieldEditor gridSize;
	private BooleanFieldEditor snapToGeometry;

	public GraphicalEditorPreferencePage() {
		super("Flow Editor Preferences");
	}

	protected Control createContents(Composite parent) {
		Composite composite = new Composite(parent, SWT.NULL);
		composite.setLayout(new GridLayout(1, false));
		composite.setLayoutData(new GridData(GridData.FILL_BOTH));
		
		// for Diagram Layout (Grid)
		Group gridGroup = new Group(composite, SWT.NULL);
		gridGroup.setText(StrutsPlugin.getResourceString("preference.flow.grid"));
		gridGroup.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		showGrid = new BooleanFieldEditor(StrutsPlugin.PREF_SHOW_GRID, 
				StrutsPlugin.getResourceString("preference.flow.show.grid"), gridGroup);
		gridSize = new SpinnerFieldEditor(StrutsPlugin.PREF_GRID_SIZE, 
				StrutsPlugin.getResourceString("preference.flow.grid.size"), 1, 100, gridGroup);
		snapToGeometry = new BooleanFieldEditor(StrutsPlugin.PREF_SNAP_GEOMETRY, 
				StrutsPlugin.getResourceString("preference.flow.snap"), gridGroup);
		gridGroup.setLayout(new GridLayout(3, false));
		
		// Initializes values
		fillInitialValues();
		
		return composite;
	}

	private void fillInitialValues() {
		IPreferenceStore store = StrutsPlugin.getDefault().getPreferenceStore();

		showGrid.setPreferenceStore(store);
		showGrid.load();
		
		gridSize.setPreferenceStore(store);
		gridSize.load();
		
		snapToGeometry.setPreferenceStore(store);
		snapToGeometry.load();
	}

	public boolean performOk() {
		showGrid.store();
		gridSize.store();
		snapToGeometry.store();
		return true;
	}

	public void init(IWorkbench workbench) {
	}

}